/* cv_cli_reverse.c: CLI utility program to perform an auth reversal. */
/* Author: Doug DeJulio, ddj@hks.net, 19980408 */

static const char rcsid[] = "$Id: cv_cli_reverse.c,v 1.1 1998/04/08 16:03:33 ddj Exp $";

#include <stdio.h>
#include <stdlib.h>		/* getenv() */
#include <unistd.h>		/* getopt() */

#include "cv_api.h"

int main(int argc, char *argv[])
{
  char *config = NULL;		/* Configuration name. */
  char *invoice = NULL;		/* Invoice to "reverse". */
  extern char *optarg;
  extern int optind, opterr, optopt;
  int opt;
  void *session;
  int r;

  /* Process arguments. */
  /* Configuration name is specified by -C or an environment variable. */
  while ((opt = getopt(argc, argv, "C:")) != EOF) {
    switch (opt) {
    case 'C':			/* Configuration name. */
      config = optarg;		/* Store it. */
      break;
    case '?':			/* Unknown option, give warning. */
      fprintf(stderr, "%s: unknown option '%c', ignoring...\n",
	      argv[0], optopt);
    }
  }

  if ((argc - optind) != 1) {
    fprintf(stderr, "usage: %s [-C configname] invoice\n", argv[0]);
    return 1;
  }

  /* First non-switch argument is the invoice to use. */
  invoice = argv[optind];
  /* Arguments handled. */

  /* Initialize with configuration name. */
  if (config == NULL) {		/* No config argument? */
    config = getenv("CCVS_CONFIG_NAME");
    if (config == NULL) {	/* No config argument & no env var. */
      fprintf(stderr,
	      "%s: You must specify a configuration.\n",
	      argv[0]);
      return 1;
    }
  }

  /* Config name and invoice are both set now. */
  session = cv_init(config);
  if (session == CV_SESS_BAD) {
    fprintf(stderr,
	    "%s: Unable to initialize with configuration '%s'.\n",
	    argv[0], config);
    return 1;
  }

  r = cv_reverse(session, invoice);
  
  switch (r) {
  case CV_OK:
    printf("%s: Transaction '%s' processed.\n",
	   argv[0], invoice);
    break;
  case CV_E_DUPINVOICE:
  case CV_E_BADINVOICE:
    printf("%s: Invalid operation on transaction '%s'.\n",
	   argv[0], invoice);
    break;
  case CV_E_NOTIMPLEMENTED:
    printf("%s: Not implemented for this protocol.\n",
	   argv[0]);
    break;
  default:
    printf("%s: Unknown problem processing transaction '%s'.\n",
	   argv[0], invoice);
  }

  /* Clean up. */
  cv_done(session);

  return r;
}
  
