#!/usr/bin/tclsh
# list.tcl: CCVS TCL demo program to list all transactions in the system.
# Author: Doug DeJulio, ddj@hks.net, 970721
# $Id: list.tcl,v 1.4 1998/10/30 23:27:35 ddj Exp $

# This program will list all the transactions currently stored in the system.
# This will include transactions that have been authorized but not yet used
# in a sale, as well as all the pending sales and returns that will be sent
# in the next upload.  Every invoice that's in use will be shown.

# To use it, the first line must be changed to reflect the location of your
# TCL interpreter, and these next two lines must be changed to reflect your
# local CCVS installation.
set cv_lib /usr/local/ccvs/lib/tcl/ccvs.so
set cv_config demo

# Initialize
puts [load $cv_lib]
puts [cv_init $cv_config]

# Count the number of transactions in each queue.
set states {new unauth auth review denied ready done bad}

proc cv_display {invoice} {
    array set r [cv_status $invoice]
    foreach key [array names r] {
	puts "$key: $r($key)"
    }
    puts "-----"
}

foreach state $states {
    set count [cv_count "$state"]
    puts "==== $state $count ===="
    for {set i 1} {$i <= $count} {set i [expr $i + 1]} {
	set invoice [cv_lookup $state $i]
	if {[string compare $invoice NONE] != 0} {
	    cv_display $invoice
	}
    }
}
