package CCVS;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	CV_ALL
	CV_ARG_ACCOUNTNAME
	CV_ARG_AMOUNT
	CV_ARG_AVS_ADDRESS
	CV_ARG_AVS_ZIPCODE
	CV_ARG_BANKACCNUM
	CV_ARG_CARDNUM
	CV_ARG_CHECKNUM
	CV_ARG_COMMENT
	CV_ARG_DVS_LICENSENUM
	CV_ARG_DVS_LICENSESTATE
	CV_ARG_END
	CV_ARG_EXPDATE
	CV_ARG_MAX
	CV_ARG_STATUS
	CV_ARG_TROUTNUM
	CV_ARG_TYPE
	CV_AUTH
	CV_BAD
	CV_DENIED
	CV_DONE
	CV_E_ACTIONREQUIRED
	CV_E_AVSFAIL
	CV_E_BADINVOICE
	CV_E_BUG
	CV_E_COMMERROR
	CV_E_DATA
	CV_E_DUPINVOICE
	CV_E_INVALID
	CV_E_NEGRESPONSE
	CV_E_NOTDONE
	CV_E_NOTIMPLEMENTED
	CV_E_SYNTAXERROR
	CV_E_UNKNOWN
	CV_NEW
	CV_NONE
	CV_OK
	CV_READY
	CV_REVIEW
	CV_SESS_BAD
	CV_UNAUTH
);
$VERSION = '3.0';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
	if ($! =~ /Invalid/) {
	    $AutoLoader::AUTOLOAD = $AUTOLOAD;
	    goto &AutoLoader::AUTOLOAD;
	}
	else {
		croak "Your vendor has not defined CCVS macro $constname";
	}
    }
    eval "sub $AUTOLOAD { $val }";
    goto &$AUTOLOAD;
}

bootstrap CCVS $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

CCVS - Perl extension for conducting financial transactions

=head1 SYNOPSIS

  use CCVS;

=head1 DESCRIPTION

The CCVS extension for Perl provides access to routines usefull for
processing credit cards in your Perl scripts.  All of the functions
availble in the CCVS API for the C language are available.  For each
cv_* function in the C API, there's a similar function named CCVS::*
in the Perl module.  So, for example, you would use CCVS::init to
initialize the system.

The only function missing from the Perl API is cv_create().  This is a
deprecated function, and all of its functionality is available via the
newer cv_add() and cv_new() (or CCVS::add() and CCVS::new())
functions.  If you've written code using the specialized replacement
create fuctions from our old Perl interface, that code will continue
to work, but new code should use the newer functions.

For more details, consult the C documentation.

=head1 Exported constants

  CV_ALL
  CV_ARG_ACCOUNTNAME
  CV_ARG_AMOUNT
  CV_ARG_AVS_ADDRESS
  CV_ARG_AVS_ZIPCODE
  CV_ARG_BANKACCNUM
  CV_ARG_CARDNUM
  CV_ARG_CHECKNUM
  CV_ARG_COMMENT
  CV_ARG_DVS_LICENSENUM
  CV_ARG_DVS_LICENSESTATE
  CV_ARG_END
  CV_ARG_EXPDATE
  CV_ARG_MAX
  CV_ARG_STATUS
  CV_ARG_TROUTNUM
  CV_ARG_TYPE
  CV_AUTH
  CV_BAD
  CV_DENIED
  CV_DONE
  CV_E_ACTIONREQUIRED
  CV_E_AVSFAIL
  CV_E_BADINVOICE
  CV_E_BUG
  CV_E_COMMERROR
  CV_E_DATA
  CV_E_DUPINVOICE
  CV_E_INVALID
  CV_E_NEGRESPONSE
  CV_E_NOTDONE
  CV_E_NOTIMPLEMENTED
  CV_E_SYNTAXERROR
  CV_E_UNKNOWN
  CV_NEW
  CV_NONE
  CV_OK
  CV_READY
  CV_REVIEW
  CV_SESS_BAD
  CV_UNAUTH


=head1 AUTHOR

HKS, Inc., support@hks.net

=head1 SEE ALSO

perl(1), ccvs(3).

=cut
