/* cvphp.c: PHP3 module for CCVS. */
/* Author: Doug DeJulio, ddj@hks.net, 1998/08/11 */

static char const rcsid[] = "$Id: cvphp.c,v 1.1 1998/10/30 20:37:50 ddj Exp $";

#include <phpdl.h>

#include <cv_api.h>
#include <stdlib.h>
#include <string.h>

/* Declare functions not in cv_api.h but in libccvs.a. */
char *hks_ptr_ptrtostring(void *vptr);
void *hks_ptr_stringtoptr(char *str);

DLEXPORT void cv_php_init(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *name;
  void *vsess;
  char *p;

  if (ARG_COUNT(ht) != 1
      || getParameters(ht, 1, &name) == FAILURE)
    {
      WRONG_PARAM_COUNT;
    }

  convert_to_string(name);

  vsess = cv_init(name->value.str.val);
  /* Convert the (void*) into a string representation. */
  p = hks_ptr_ptrtostring(vsess);

  RETVAL_STRING(p, 1);
  free(p);

  return;
}

DLEXPORT void cv_php_done(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *sess;
  void *vsess;

  if (ARG_COUNT(ht) != 1
      || getParameters(ht, 1, &sess) == FAILURE)
    {
      WRONG_PARAM_COUNT;
    }

  convert_to_string(sess);

  /* Convert from the string representation back to a (void*) */
  vsess = hks_ptr_stringtoptr(sess->value.str.val);
  cv_done(vsess);

  RETURN_STRING("OK", 1);
}

DLEXPORT void cv_php_new(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;

  r = cv_new(sess, invoice);

  RETURN_STRING(cv_ret2str(r), 1);
}

DLEXPORT void cv_php_add(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  pval *pargtype;
  pval *pargval;
  void *sess;
  char *invoice;
  int argtype;
  char *argval;
  register int r;

  if (ARG_COUNT(ht) != 4
      || getParameters(ht, 4,
		       &psess, &pinvoice, &pargtype, &pargval) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  /* Get meaningful arguments. */
  convert_to_string(psess);
  convert_to_string(pinvoice);
  convert_to_string(pargtype);
  convert_to_string(pargval);
  sess = hks_ptr_stringtoptr(psess->value.str.val);
  invoice = pinvoice->value.str.val;
  argtype = cv_str2arg(pargtype->value.str.val);
  argval = pargval->value.str.val;

  r = cv_add(sess, invoice, argtype, argval);

  RETURN_STRING(cv_ret2str(r), 1);
}

/* cv_create can't be implemented because of vararg limits in PHP3's C API. */

DLEXPORT void cv_php_delete(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_delete(sess, invoice);

  RETURN_STRING(cv_ret2str(r), 1);
}

DLEXPORT void cv_php_auth(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_auth(sess, invoice);

  RETURN_STRING(cv_ret2str(r), 1);
}

DLEXPORT void cv_php_return(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_return(sess, invoice);

  RETURN_STRING(cv_ret2str(r), 1);
}

DLEXPORT void cv_php_reverse(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_reverse(sess, invoice);

  RETURN_STRING(cv_ret2str(r), 1);
}

DLEXPORT void cv_php_sale(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_sale(sess, invoice);

  RETURN_STRING(cv_ret2str(r), 1);
}

DLEXPORT void cv_php_status(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *pinvoice;
  void *sess;
  char *invoice;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &pinvoice) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(pinvoice);
  invoice = pinvoice->value.str.val;
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_status(sess, invoice);

  RETURN_STRING(cv_stat2str(r), 1);
}

DLEXPORT void cv_php_count(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *ptype;
  void *sess;
  int type;
  register int r;

  if (ARG_COUNT(ht) != 2
      || getParameters(ht, 2, &psess, &ptype) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  convert_to_string(ptype);
  type = cv_str2stat(ptype->value.str.val);
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  r = cv_count(sess, type);

  RETURN_LONG(r);
}

DLEXPORT void cv_php_lookup(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  pval *ptype;
  pval *pinum;
  void *sess;
  int type;
  long inum;
  register int r;

  if (ARG_COUNT(ht) != 3
      || getParameters(ht, 3, &psess, &ptype, &pinum) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  sess = hks_ptr_stringtoptr(psess->value.str.val);
  convert_to_string(ptype);
  type = cv_str2stat(ptype->value.str.val);
  convert_to_long(pinum);
  inum = pinum->value.lval;

  r = cv_lookup(sess, type, inum);

  RETURN_STRING(cv_textvalue(sess), 1);
}

DLEXPORT void cv_php_textvalue(INTERNAL_FUNCTION_PARAMETERS)
{
  pval *psess;
  void *sess;

  if (ARG_COUNT(ht) != 1
      || getParameters(ht, 1, &psess) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string(psess);
  sess = hks_ptr_stringtoptr(psess->value.str.val);

  RETURN_STRING(cv_textvalue(sess), 1);
}

function_entry ccvs_functions[] = {
  {"cv_init", cv_php_init},
  {"cv_done", cv_php_done},
  {"cv_new", cv_php_new},
  {"cv_add", cv_php_add},
  {"cv_delete", cv_php_delete},
  {"cv_auth", cv_php_auth},
  {"cv_return", cv_php_return},
  {"cv_reverse", cv_php_reverse},
  {"cv_sale", cv_php_sale},
  {"cv_status", cv_php_status},
  {"cv_count", cv_php_count},
  {"cv_lookup", cv_php_lookup},
  {"cv_textvalue", cv_php_textvalue},
  {NULL,NULL}
};

php3_module_entry ccvs_module_entry = {
  "CCVS", ccvs_functions, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, NULL
};

DLEXPORT php3_module_entry *get_module(void) { return &ccvs_module_entry; }
