// File: net.hks.Ccvs class

package net.hks;

/*
 * This ccvs java class is version 3.0 and above of CCVS.
 */

/*
 * $Id: Ccvs.java,v 1.7 1998/11/05 21:46:57 zarf Exp $
 */

public class Ccvs {
  static {
    System.loadLibrary("ccvsjni");
  }

  private java.lang.String mysession;

  public Ccvs(java.lang.String configuration) throws CcvsException {
    mysession = cvinit(configuration); 
    if (mysession.equals("NULL")) {
      throw new CcvsException("Could not initialize CCVS");
    }
  }

  public void finalize() {
    cvdone(mysession);
  }

  /* This came from cvapi.h */

  public static final int CV_OK = 0;

  public static final int CV_ARG_END = 0;
  public static final int CV_ARG_AMOUNT = 1;
  public static final int CV_ARG_CARDNUM = 2;
  public static final int CV_ARG_EXPDATE = 3;
  public static final int CV_ARG_AVS_ADDRESS = 4;
  public static final int CV_ARG_AVS_ZIPCODE = 5;
  public static final int CV_ARG_COMMENT = 6;
  public static final int CV_ARG_TYPE = 7;
  public static final int CV_ARG_STATUS = 8;
  public static final int CV_ARG_TROUTNUM = 9;
  public static final int CV_ARG_BANKACCNUM = 10;
  public static final int CV_ARG_CHECKNUM = 11;
  public static final int CV_ARG_DVS_LICENSENUM = 12;
  public static final int CV_ARG_DVS_LICENSESTATE = 13;
  public static final int CV_ARG_ACCOUNTNAME = 14;
  public static final int CV_ARG_ACCOUNTTYPE = 15;
  public static final int CV_ARG_MAX = 16;

  public static final int CV_E_NEGRESPONSE = 1;
  public static final int CV_E_ACTIONREQUIRED = 2;
  public static final int CV_E_AVSFAIL = 3;
  public static final int CV_E_NOTDONE = 4;
  public static final int CV_E_INVALID = 5;
  public static final int CV_E_COMMERROR = -1;
  public static final int CV_E_SYNTAXERROR = -2;
  public static final int CV_E_DUPINVOICE = -3;
  public static final int CV_E_BADINVOICE = -4;
  public static final int CV_E_DATA = -5;
  public static final int CV_E_BUG = -6;
  public static final int CV_E_UNINIT = -7;
  public static final int CV_E_UNKNOWN = 128;
  public static final int CV_E_NOTIMPLEMENTED = -128;

  public static final int CV_NONE = 0;
  public static final int CV_NEW = 1;
  public static final int CV_AUTH = 2;
  public static final int CV_READY = 4;
  public static final int CV_DONE = 8;
  public static final int CV_UNAUTH = 16;
  public static final int CV_DENIED = 32;
  public static final int CV_REVIEW = 64;
  public static final int CV_BAD = 128;
  public static final int CV_ALL = 255;

  private native static String cvinit(java.lang.String initFileName);
  private native static void cvdone(java.lang.String sesptr);

  private native static int cvauth(java.lang.String sesptr,
				  java.lang.String invoice);
  public int cv_auth(java.lang.String invoice) {
    return cvauth(mysession, invoice);
  }

  private native static int cvnew(java.lang.String sesptr,
				  java.lang.String invoice);
  public int cv_new(java.lang.String invoice) {
    return cvnew(mysession, invoice);
  }

  private native static int cvadd(java.lang.String sesptr,
				  java.lang.String invoice,
				  int argtype,
				  java.lang.String argval);
  public int cv_add(java.lang.String invoice, int argtype, 
		    java.lang.String argval) {
    return cvadd(mysession, invoice, argtype, argval);
  }

  private native static int cvsale(java.lang.String sesptr,
				  java.lang.String invoice);
  public int cv_sale(java.lang.String invoice) {
    return cvsale(mysession, invoice);
  }

  private native static int cvreturn(java.lang.String sesptr,
				    java.lang.String invoice);
  public int cv_return(java.lang.String invoice) {
    return cvreturn(mysession, invoice);
  }

  private native static int cvreverse(java.lang.String sesptr,
				     java.lang.String invoice);
  public int cv_reverse(java.lang.String invoice) {
    return cvreverse(mysession, invoice);
  }

  private native static int cvdelete(java.lang.String sesptr,
                                    java.lang.String invoice);
  public int cv_delete(java.lang.String invoice) {
    return cvdelete(mysession, invoice);
  }

  private native static int cvstatus(java.lang.String sesptr,
				    java.lang.String invoice);
  public int cv_status(java.lang.String invoice) {
    return cvstatus(mysession, invoice);
  }

  private native static int cvcount(java.lang.String sesptr,
				    int type);
  public int cv_count(int type) {
    return cvcount(mysession, type);
  }

  private native static int cvlookup(java.lang.String sesptr,
				    java.lang.String invoice,
				    int type,
				    int itemnum);
  public int cv_lookup(java.lang.String invoice,
		      int type,
		      int itemnum) {
    return cvlookup(mysession, invoice, type, itemnum);
  }

  private native static String cvtextvalue(java.lang.String sesptr);
  public String cv_textvalue() {
    return cvtextvalue(mysession);
  }

  private native static String cvret2str(int val);
  public static String errorString(int stat) {
    return cvret2str(stat);
  }

  private native static String cvstat2str(int val);
  public static String statusString(int stat) {
    return cvstat2str(stat);
  }
}






