/* File: ccvsjni.c, JNI support for CCVS Java module */
/* Author: Todd Masco, cactus@hks.net, 1998/07/31 */

static const char * const rcsid = "$Id: ccvsjni.c,v 1.8 1998/11/05 21:46:57 zarf Exp $";


#include <stdio.h>
#include <ctype.h>
#include "net_hks_Ccvs.h"
#include "cv_api.h"

#define FREE(a) { if ((a)) free((a)); }

static int pointerToStrings(JNIEnv *env, void **p, jstring *jpointer);
static int stringsToPointer(JNIEnv *env, jstring pointer,void **p);
static char *copyconjstr(JNIEnv *env, jstring a);

char *hks_util_strdup(char *orig_str);

JNIEXPORT jstring JNICALL
Java_net_hks_Ccvs_cvinit(JNIEnv *env, jobject thisObj, jstring jconfname) {
  char *confname;
  void *session;

  jstring pointstr;

  confname = copyconjstr(env, jconfname);
  session = cv_init(confname);

  FREE(confname);

  pointerToStrings(env, &session, &pointstr);

  return pointstr;
}


JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvscreate(JNIEnv *env, jobject thisObj,
		   jstring sesptr, jstring jinvoice,
		   jstring amount, jstring cardno, jstring expdate) {

  char *cardnostr, *amountstr, *expdatestr, *invoice;

  jint ret;
  jclass clazz;
  jboolean isCopy;
  jobject obj;
  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  cardnostr = copyconjstr(env, cardno);
  amountstr = copyconjstr(env, amount);
  expdatestr = copyconjstr(env, expdate);

  ret = cv_create(session, invoice, 
		  CV_ARG_AMOUNT, amountstr,
		  CV_ARG_CARDNUM, cardnostr,
		  CV_ARG_EXPDATE, expdatestr,
		  CV_ARG_END);

  FREE(invoice);
  FREE(cardnostr);
  FREE(amountstr);
  FREE(expdatestr);

  return ret;

}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvsale(JNIEnv *env, jobject thisObj, jstring sesptr,
		 jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_sale(session, invoice);
  FREE(invoice);

  return ret;
}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvstatus(JNIEnv *env, jobject thisObj, jstring sesptr,
		 jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_status(session, invoice);
  FREE(invoice);

  return ret;
}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvreverse(JNIEnv *env, jobject thisObj, jstring sesptr,
		    jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_reverse(session, invoice);
  FREE(invoice);

  return ret;
}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvreturn(JNIEnv *env, jobject thisObj, jstring sesptr,
		   jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_return(session, invoice);
  FREE(invoice);

  return ret;
}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvdelete(JNIEnv *env, jobject thisObj, jstring sesptr,
		   jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_delete(session, invoice);
  FREE(invoice);

  return ret;
}


JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvauth(JNIEnv *env, jobject thisObj, jstring sesptr,
		 jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_auth(session, invoice);
  FREE(invoice);

  return ret;
}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvnew(JNIEnv *env, jobject thisObj, jstring sesptr,
		 jstring jinvoice)
{
  char *invoice;
  jint ret;

  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  ret = cv_new(session, invoice);
  FREE(invoice);

  return ret;
}

JNIEXPORT jint JNICALL
Java_net_hks_Ccvs_cvadd(JNIEnv *env, jobject thisObj, jstring sesptr,
		 jstring jinvoice, jint argtype, jstring jargval)
{
  char *invoice, *argval;
  jint ret;
  void *session;

  stringsToPointer(env, sesptr, &session);

  invoice = copyconjstr(env, jinvoice);
  argval =  copyconjstr(env, jargval);
  ret = cv_add(session, invoice, argtype, argval);
  FREE(invoice);
  FREE(argval);

  return ret;
}

JNIEXPORT jstring JNICALL
Java_net_hks_Ccvs_cvtextvalue(JNIEnv *env, jobject thisObj, jstring sesptr)
{
  void *session;
  char *value;
  jstring jvalue;

  stringsToPointer(env, sesptr, &session);

  value = cv_textvalue(session);
  jvalue = (*env)->NewStringUTF(env,value);

  return jvalue;
}

JNIEXPORT jstring JNICALL
Java_net_hks_Ccvs_cvret2str(JNIEnv *env, jobject thisObj, jint val)
{
  char *value;
  jstring jvalue;

  value = cv_ret2str(val);
  jvalue = (*env)->NewStringUTF(env,value);

  return jvalue;
}

JNIEXPORT jstring JNICALL
Java_net_hks_Ccvs_cvstat2str(JNIEnv *env, jobject thisObj, jint val)
{
  char *value;
  jstring jvalue;

  value = cv_stat2str(val);
  jvalue = (*env)->NewStringUTF(env,value);

  return jvalue;
}

JNIEXPORT void JNICALL
Java_net_hks_Ccvs_cvdone(JNIEnv *env, jobject thisObj, jstring sesptr)
{
  void *session;

  stringsToPointer(env, sesptr, &session);

  cv_done(session);
}


static int stringsToPointer(JNIEnv *env, jstring pointer,void **p)
{
  jboolean isCopy;
  char *pstr;
  void *v;
  char *Hex = "0123456789ABCDEF";
  int sizeint;
  int found, fnibble, snibble;
  unsigned char *bytes;
  int i, j;

  sizeint = sizeof(void *);

  bytes = (unsigned char *) malloc(1+sizeint);

  pstr = copyconjstr(env, pointer);

  for (i=0;i<sizeint;i++) {
    found = -1;
    for (j=0;Hex[j] && (found == -1);j++) {
      if ((toupper(pstr[2*i])) == (toupper(Hex[j])))
	found = j;
    }
    fnibble = found;

    found = -1;
    for (j=0;Hex[j] && (found == -1);j++) {
      if ((toupper(pstr[(2*i)+1])) == (toupper(Hex[j])))
	found = j;
    }
    snibble = found;

    bytes[i] = (snibble) | (fnibble << 4);
  }

  *p = *((void **) bytes);

  FREE(pstr);

  return 0;
}

static int pointerToStrings(JNIEnv *env, void **p, jstring *jpointer)
{
  int size, i;
  char sizestr[32];
  char pointstr[128];
  
  unsigned char *bytes;

  if ( *p != NULL) {
    size = sizeof(void *);

    bytes = (unsigned char *) p;
    
    for (i = 0; i < size; i++) 
      sprintf(pointstr+(i*2),"%02x",bytes[i]);
  
    pointstr[i*2] = '\0';
  }
  else {
    sprintf(pointstr,"NULL");
  }

  (*jpointer) = (*env)->NewStringUTF(env,pointstr);

  return 0;
}

static char *copyconjstr(JNIEnv *env, jstring str)
{
  char *copy;
  const char *utf_string;
  jboolean isCopy;

  utf_string = (*env)->GetStringUTFChars(env, str, &isCopy);
  copy = hks_util_strdup((char *)utf_string);
  if (isCopy == JNI_TRUE) {
    (*env)->ReleaseStringUTFChars(env, str, utf_string);
  }

  return copy;
}







