#!/usr/bin/perl
# cvphpconfig.pl: Generate a Makefile for CCVS PHP3 extension.
# Author: Doug DeJulio, ddj@hks.net, 1998/10/30
# $Id: cvphpconfig.pl,v 1.2 1998/10/30 21:00:52 ddj Exp $

# These variables may differ under MacOS or Win32.
$defccvsdir = "/usr/local/ccvs";
$libdir = "/lib/";
$incdir = "/include";
$libname = $libdir . "libccvs.a";

# Prompt for some info if neccesary.
# This all pertains to the CCVS install.
do {
    if (-e $defccvsdir . $libname) {
	$ccvsdir = $defccvsdir;
	$done = 1;
    } else {
	print "What did you chose as the install directory for CCVS? ";
	chop($ccvsdir = <STDIN>);
	if ($ccvsdir !~ m%/ccvs$%) {
	    $ccvsdir .= "/ccvs";
	}
    }
    
    $libfile = $ccvsdir . $libname;
    
    if ( -e $libfile) {
	$done = 1;
    } else {
	print "I can't find the CCVS library at ", $libfile, "\n";
	$done = 0;
    }
	
} while (!$done);

# Find the PHP include files.
do {
    print "In what directory is your php.h file? ";
    chop ($phpinc = <STDIN>);
    if (-e $phpinc . "/php.h") {
	$done = 1;
    } else {
	$done = 0;
    }
} while (!$done);

# Find the include file for dynamic linking.
if (! -e $phpinc . "/phpdl.h") {
    do {
	print "In what directory is your phpdl.h file? ";
	chop ($phpdl = <STDIN>);
	if (-e $phpdl . "/phpdl.h") {
	    $done = 1;
	} else {
	    $done = 0;
	}
    } while (!$done);
}

# Find the PHP3 config file.
if (! -e $phpinc . "/config.h"
    && ! -e $phpdl . "/config.h") {
    do {
	print "In what directory is your PHP3 config.h file? ";
	chop ($phpconf = <STDIN>);
	if (-e $phpconf . "/config.h") {
	    $done = 1;
	} else {
	    $done = 0;
	}
    } while (!$done);
}

# Now, we need any strange libraries.

# libphp, eg. for apache?
do {
    print "Sometimes, you need to link in a PHP3 library.  This is often\n";
    print "the case if you're using the PHP3 Apache module, for example.\n";
    print "Do you need to link in the PHP3 library? ";
    chop ($answer = <STDIN>);
    if ($answer =~ m/^[yY]/) {
	print "Where is the PHP3 library? ";
	chop($phplibdir = <STDIN>);
	print "How do you link it? (Usually \"-lphp3\") ";
	chop($phpliblnk = <STDIN>);
	$done = 1;
    } elsif ($answer =~ m/^[nN]/) {
	$done = 1;
    } else {
	$done = 0;
    }
} while (!$done);

# Anything else?  (eg. "-lsocket" on SCO)
do {
    print "Sometimes, you need to link against additonal libraries.  For\n";
    print "example, on SCO you may need to link against the socket library.\n";
    print "Do you need to link against any other libraries? ";
    chop ($answer = <STDIN>);
    if ($answer =~ m/^[yY]/) {
	print "How do you link them in? (eg. \"-lsocket\") ";
	chop ($otherlib = <STDIN>);
	$done = 1;
    } elsif ($answer =~ m/^[nN]/) {
	$done = 1;
    } else {
	$done = 0;
    }
} while (!$done);

# Where does it all go?
do {
    print "Where do you want to install the PHP3 module? ";
    chop ($dest = <STDIN>);
    if (! -d $dest) {
	print "That's not a directory!\n";
	$done = 0;
    } else {
	$done = 1;
    }
} while (!$done);

# Build up the required -I stuff.
$inc = "-I" . $ccvsdir . $incdir;
$inc .= " -I" . $phpinc;
$inc .= " -I" . $phpdl if ($phpdl);
$inc .= " -I" . $phpconf if ($phpconf);
$inc .= " -I" . $otherinc if ($otherinc);

# Build up the required -L/-l stuff.
$lib = "-L" . $ccvsdir . $libdir . " -lccvs";
$lib .= "-L" . $phplibdir if ($phplibdir);
$lib .= " " . $phpliblnk if ($phpliblnk);
$lib .= " " . $otherlib if ($otherlib);
$lib .= " -lc";

print "Writing Makefile...";

# Generate the Makefile!
open(MAKE, ">Makefile");
print MAKE
    "# Makefile generated by cvphpconfig.pl\n",
    "# The following is good for GCC on most ELF binutil systems.\n",
    "INCLUDES=" . $inc . "\n",
    "LIBS=" . $lib . "\n",
    "CFLAGS=-fPIC \$(INCLUDES) -DCOMPILE_DL\n",
    "\n",
    "install: cvphp.so\n",
    "\tcp cvphp.so " . $dest . "\n",
    "\n",
    "cvphp.so: cvphp.o\n",
    "\t\$(CC) \$(CFLAGS) -shared -Wl,-soname,cvphp.so -o cvphp.so cvphp.o \$(LIBS)\n",
    "\n",
    "cvphp.o: cvphp.c\n",
    "\t\$(CC) \$(CFLAGS) -c -o cvphp.o cvphp.c\n",
    "\n";

# All done!

print "done.\n";
