/* cv_cli_delete.c: CLI utility program to delete a transaction. */
/* Author: Doug DeJulio, ddj@hks.net, 19970919 */

static const char rcsid[] = "$Id: cv_cli_delete.c,v 1.4 1999/02/22 17:07:09 ddj Exp $";

#include <stdio.h>		/* printf() */
#include <stdlib.h>		/* getenv() */
#include <unistd.h>		/* getopt() */

#include "cv_api.h"		/* CCVS C API */

int main(int argc, char *argv[])
{
  char *config = NULL;		/* Configuration name. */
  char *invoice = NULL;		/* Invoice to delete. */
  extern char *optarg;
  extern int optind, opterr, optopt;
  int opt;
  void *session;
  int r;

  int versp = 0;

  /* Process arguments. */
  /* Configuration name is specified by -C or an environment variable. */
  while ((opt = getopt(argc, argv, "c:C:V")) != EOF) {
    switch (opt) {
    case 'c':
    case 'C':			/* Configuration name. */
      config = optarg;		/* Store it. */
      break;
    case 'V':
      versp = 1;
      break;
    case '?':			/* Unknown option, give warning. */
      fprintf(stderr, "%s: unknown option '%c', ignoring...\n",
	      argv[0], optopt);
    }
  }

  if (!versp && (argc - optind) != 1) {
    fprintf(stderr, "usage: %s [-C configname] [-V | invoice]\n", argv[0]);
    return 1;
  }

  /* First non-switch argument is the invoice to use. */
  invoice = argv[optind];
  /* Arguments handled. */

  /* Initialize with configuration name. */
  if (config == NULL) {		/* No config argument? */
    config = getenv("CCVS_CONFIG_NAME");
    if (config == NULL) {	/* No config argument & no env var. */
      fprintf(stderr,
	      "%s: You must specify a configuration.\n",
	      argv[0]);
      return 1;
    }
  }

  /* Config name and invoice are both set now. */
  session = cv_init(config);
  if (session == CV_SESS_BAD) {
    fprintf(stderr,
	    "%s: Unable to initialize with configuration '%s'.\n",
	    argv[0], config);
    return 1;
  }

  /* Do we just report CCVS version info and exit now? */
  if (versp) {
    puts(cv_textvalue(session)); /* Print the version. */
    cv_done(session);		/* Close the session. */
    return 0;			/* Terminate. */
  }


  r = cv_delete(session, invoice);

  switch (r) {
  case CV_OK:
    printf("%s: Transaction '%s' deleted.\n",
	   argv[0], invoice);
    break;
  case CV_E_DUPINVOICE:
  case CV_E_BADINVOICE:
    printf("%s: Invalid operation on transaction '%s'.\n",
	   argv[0], invoice);
    break;
  default:
    printf("%s: Unknown problem deleting transaction '%s'.\n",
	   argv[0], invoice);
  }

  /* Clean up. */
  cv_done(session);

  return r;
}
