#!/usr/bin/python
# cvdemo.py: Demo of CCVS module for Python
# Author: Doug DeJulio, ddj@hks.net, 1998/10/20
# $Id: cvdemo.py,v 1.2 1998/10/30 23:34:42 ddj Exp $

# First, load the CCVS module.
# For this to work, set the PYTHONPATH environment variable to include
# the directory that "ccvsmodule.so" is installed in.  This defaults
# to "/usr/local/ccvs/lib/python" on most systems.
import ccvs

# Next, initialize a session.
s = ccvs.init("demo")

# Create a transaction, and set it up for whatever you want to do.
# For a credit card charge, it must have an amount, card number,
# and expiration date.
ccvs.new(s, "pydem001")
ccvs.add(s, "pydem001", "amount", "49.95")
ccvs.add(s, "pydem001", "cardnum", "0000 0000 00000")
ccvs.add(s, "pydem001", "expdate", "02/03")

# Now, do the authorization.
result = ccvs.auth(s, "pydem001")

# The actual result of the auth isn't known immediately.  We have
# to wait until the transaction is processed by the background processor.
