use ExtUtils::MakeMaker;

# These variables may differ under MacOS or Win32.
$defccvsdir = "/usr/local/ccvs";
$libdir = "/lib/";
$incdir = "/include";
$libname = $libdir . "libccvs.a";

# Prompt for some info if neccesary.
do {
    if (-e $defccvsdir . $libname) {
	$ccvsdir = $defccvsdir;
	$done = 1;
    } else {
	print "What did you chose as the install directory for CCVS? ";
	chop($ccvsdir = <STDIN>);
	if ($ccvsdir !~ m%/ccvs$%) {
	    $ccvsdir .= "/ccvs";
	}
    }
    
    $libfile = $ccvsdir . $libname;
    
    if ( -e $libfile) {
	$done = 1;
    } else {
	print "I can't find the CCVS library at ", $libfile, "\n";
	$done = 0;
    }
	
} while (!$done);

# Write the Makefile.
WriteMakefile(
    'NAME'	=> 'CCVS',
    'VERSION_FROM' => 'CCVS.pm', # finds $VERSION
    'LIBS'	=> ["-L" . $ccvsdir . $libdir . " -lccvs -lc",
                    "-L" . $ccvsdir . $libdir . " -lccvs"],
    'DEFINE'	=> '',     # e.g., '-DHAVE_SOMETHING' 
    'INC'	=> "-I" . $ccvsdir . $incdir,
);

# Explain some things to the user.
print "\nRemember that if you want to do a 'make test', it has to be done\n";
print "as the CCVS user, and if you want to do a 'make install', it has\n";
print "to be done as the user with permission to install Perl modules.\n";
