/* cv_api.h: The external, exported API for CCVS. */
/* Author: Doug DeJulio, ddj@hks.net, 970313 */
/* $Id: cv_api.h,v 1.43 2000/04/03 21:16:43 aplotkin Exp $ */

#ifndef _CV_API_H
#define _CV_API_H

/* Constructor/Destructor */
void *cv_init(char *);		/* Initialize with given config file. */
void cv_done(void *sess);	/* Do all relevant shutdown. */
#define CV_SESS_BAD (NULL)


/* Argument types. */
#define CV_ARG_END (0)
#define CV_ARG_AMOUNT (1)
#define CV_ARG_CARDNUM (2)
#define CV_ARG_EXPDATE (3)
#define CV_ARG_AVS_ADDRESS (4)
#define CV_ARG_AVS_ZIPCODE (5)
#define CV_ARG_COMMENT (6)
#define CV_ARG_TYPE (7)
#define CV_ARG_STATUS (8)
#define CV_ARG_TROUTNUM (9)
#define CV_ARG_BANKACCNUM (10)
#define CV_ARG_CHECKNUM (11)
#define CV_ARG_DVS_LICENSENUM (12)
#define CV_ARG_DVS_LICENSESTATE (13)
#define CV_ARG_ACCOUNTNAME (14)
#define CV_ARG_ACCOUNTTYPE (15)
#define CV_ARG_PRODUCT (16)
#define CV_ARG_ACODE (17)
#define CV_ARG_TAX (18)
#define CV_ARG_TRACK1 (19)
#define CV_ARG_TRACK2 (20)
#define CV_ARG_ENTRYSOURCE (21)
#define CV_ARG_PURCHASEORDER (22)
#define CV_ARG_SHIP_ZIPCODE (23)
#define CV_ARG_ENCRYPTION (24)
#define CV_ARG_SET_MERCHANT (25)
#define CV_ARG_SET_CARDHOLDER (26)
#define CV_ARG_CVV2 (27)
#define CV_ARG_MAX (28)

/* Usage functions. */
/* cv_create() is passed session, invoice, and pairs of tag/value arguments. */
/* Finish up with a zero, or CV_ARG_END */
/* Note: this function call is deprecated; it's preferable to use the
   newer cv_new and cv_add detailed below. */
int cv_create(void *sess,
	      char *invoice, int argtype, ...);

/* This creates a totally empty transaction. */
int cv_new(void *sess, char *invoice);

/* This adds argtype/argval pairs to a transaction.  Using cv_new and
   cv_add together gets us roughly the cv_create functionality, in a
   more general way. */
int cv_add(void *sess, char *invoice, int argtype, char *argval);

/* These perform operations on transactions we've already created.
   Not all operations are valid for all transactions. */
int cv_delete(void *sess, char *invoice);

int cv_auth(void *sess, char *invoice);

int cv_return(void *sess, char *invoice);

int cv_reverse(void *sess, char *invoice);

int cv_sale(void *sess, char *invoice);

int cv_void(void *sess, char *invoice);

int cv_status(void *sess, char *invoice);

int cv_count(void *sess, int type);

int cv_lookup(void *sess, int type, int itemnum);

/* To get the text values. */
char *cv_errortext(void *sess);	/* For compatability. */
char *cv_textvalue(void *sess);

/* To fetch varioius reports from the system. */
int cv_report(void *sess, int type);

/* To send arbitrary (non-transaction) commands to the system. */
int cv_command(void *sess, int cmd, char *argval);

/* Return values. */
/* Non-error */
#define CV_OK (0)
/* Errors */
#define CV_E_NEGRESPONSE (1)
#define CV_E_ACTIONREQUIRED (2)
#define CV_E_AVSFAIL (3)
#define CV_E_NOTDONE (4)
#define CV_E_INVALID (5)
#define CV_E_COMMERROR (-1)
#define CV_E_SYNTAXERROR (-2)
#define CV_E_DUPINVOICE (-3)
#define CV_E_BADINVOICE (-4)
#define CV_E_DATA (-5)
#define CV_E_BUG (-6)
#define CV_E_UNINIT (-7)
#define CV_E_RESOURCE (-8)
#define CV_E_UNKNOWN (128)
#define CV_E_NOTIMPLEMENTED (-128)

/* Transaction states. */
#define CV_NONE (0)
#define CV_NEW (1)
#define CV_AUTH (2)
#define CV_READY (4)
#define CV_DONE (8)
#define CV_UNAUTH (16)
#define CV_DENIED (32)
#define CV_REVIEW (64)
#define CV_BAD (128)
#define CV_ALL (255)

/* Report types. */
#define CV_REP_SERVER (1)
#define CV_REP_UPLOAD (2)
#define CV_REP_MAX (3)

/* Commands for cv_command(). */
#define CV_CMD_INITIALIZE (0)
#define CV_CMD_CANCEL (1)
#define CV_CMD_RESEND (2)
#define CV_CMD_FORCEBATCH (3)
#define CV_CMD_RECEIPT (4)
#define CV_CMD_PHONENUM (5)
#define CV_CMD_MAX (6)

/* These are for use only by non-C API implementations. */
char *cv_ret2str(int retval);
int cv_str2arg(char *str);
int cv_str2stat(char *str);
char *cv_stat2str(int status);
int cv_str2cmd(char *str);

#endif /* _CV_API_H */
