
UserTag import_fields Order table
UserTag import_fields addAttr
UserTag import_fields Routine <<EOR
sub {
	my($table, $opt) = @_;
	use strict;
	my $out;
#::logDebug("options for import_fields: " . ::uneval(\@_) );
	local($SIG{__DIE__});
	$SIG{"__DIE__"} = sub {
                            my $msg = shift;
                            ::response(<<EOF);
<HTML><HEAD><TITLE>Fatal Administration Error</TITLE></HEAD><BODY>
<H1>FATAL error</H1>
<P>
<PRE>$msg</PRE>
Progress to date:
<P>
$out
</BODY></HTML>
EOF
                            exit 0;
                        };
	my $file = $opt->{'file'} || $Vend::Cfg->{ProductDir} . "/$table.update";
	my $currdb;
	my $tmsg = '';
	my $db;

	CONVERT: {
		last CONVERT if ! $opt->{convert};
		if ($opt->{convert} eq 'auto') {
			if($file =~ /\.(txt|all)$/i) {
				last CONVERT;
			}
			elsif($file =~ /\.xls$/i) {
				$opt->{convert} = 'xls';
				redo CONVERT;
			}
			else {
				$file =~ s:.*\.::
					or $file = 'none';
				return "Failed: unknown file extension ''";
			}
		}
		elsif ($opt->{convert} eq 'xls') {
#::logDebug("doing XLS for file=$file");
			eval {
				require Spreadsheet::ParseExcel;
				import Spreadsheet::ParseExcel;
				my $oExcel = new Spreadsheet::ParseExcel;

				my $oBook = $oExcel->Parse($file);
#::logDebug("oBook is $oBook");
				if(! $oBook) {
					die errmsg("Failed to parse XLS file %s: %s\n", $file, $!);
				}
				my($iR, $iC, $oWkS, $oWkC);

				my $sheets = {};

					for(my $iSheet=0; $iSheet < $oBook->{SheetCount} ; $iSheet++) {
					   my $oWkS = $oBook->{Worksheet}[$iSheet]
										or next;

					   for(qw/MaxCol MaxRow MinCol MinRow/) {
						   die "No $_!"           if ! defined $oWkS->{$_};
					   }

					   my $sname =  $oWkS->{Name} or die "no sheet name.";
#::logDebug("doing sheet $sname");
					   $sheets->{$sname} =  "$sname\n";
					   my $maxcol;
					   my $mincol;

					   my $iC;

					   my $iR = $oWkS->{MinRow};

					   for($iC = $oWkS->{MinCol} ; $iC <= $oWkS->{MaxCol} ; $iC++) {
							   $oWkC = $oWkS->{Cells}[$iR][$iC];
							   if(! $oWkC or ! $oWkC->Value) {
								  $maxcol = $iC;
								  $maxcol--;
								  last;
							   }
							   $maxcol = $iC;
					   }

					   $mincol = $oWkS->{MinCol};
					   my @out;

					   for( ; $iR <= $oWkS->{MaxRow}; $iR++) {
						  my $row = $oWkS->{Cells}[$iR];
						  @out = ();
						  for($iC = $mincol; $iC <= $maxcol; $iC++) {
							if(! defined $row->[$iC]) {
								push @out, "";
								next;
							}
							push @out, $row->[$iC]->Value;
						  }
						  $sheets->{$sname} .= join "\t", @out;
						  $sheets->{$sname} .= "\n";
					   }
					}

					my @print;
					for(sort keys %$sheets) {
						push @print, $sheets->{$_};
					}
					$file =~ s/(\.xls)?$/.txt/i;
					open OUT, ">$file"
						or die "Cannot write $file: $!\n";
					print OUT join "\cL", @print;
					close OUT;
			};
			die "Excel conversion failed: $@\n" if $@;
		}
		else {
			# other types, or assume gnumeric simple text
		}

	} # end CONVERT

	my $change_sub;
	if($opt->{multiple}) {
		undef $table;
		$change_sub = sub {
			my $table = shift;
			$Vend::WriteDatabase{$table} = 1;
#::logDebug("changing table to $table");
			$db = Vend::Data::database_exists_ref($table);
#::logDebug("db now=$db");
			die "Non-existent table '$table'\n" unless $db;
			$db = $db->ref();
#::logDebug("db now=$db");
			if($opt->{autonumber} and ! $db->config('_Auto_number') ) {
				 $db->config('AUTO_NUMBER', '1000');
			}
#::logDebug("db now=$db");
			$tmsg = "table $table: ";
			return;
		};
	}
	else {
		$Vend::WriteDatabase{$table} = 1;
		$db = Vend::Data::database_exists_ref($table);
		die "Non-existent table '$table'\n" unless $db;
		$db = $db->ref() unless $Vend::Interpolate::Db{$table};
		if($opt->{autonumber} and ! $db->config('_Auto_number') ) {
			 $db->config('AUTO_NUMBER', '1000');
		}
	}

	$out = '<PRE>';
	my $delimiter = quotemeta $opt->{delimiter} || "\t";
	open(UPDATE, $file)
		or die "read $file: $!\n";

	my $fields;

	if($opt->{multiple}) {
		# will get fields later
		undef $opt->{fields};
	}
	elsif($opt->{'fields'}) {
		$fields = $opt->{'fields'};
		$out .= "Using fields from parameter: '$fields'\n";
	}

	my $verbose;
	my $quiet;

	$verbose = 1 if ! $opt->{quiet};
	$quiet = 1   if $opt->{quiet} > 1;

  TABLE: {
	if(! $table) {
		$table = <UPDATE>;
		chomp $table;
		$change_sub->($table);
	}
#::logDebug("db now=$db");
	if(! $opt->{fields}) {
		$fields = <UPDATE>;
		chomp $fields;
		$fields =~ s/$delimiter/ /g;
		$out .= "${tmsg}Using fields from file: '$fields'\n";
	}
	die "No field names." if ! $fields;
	my @names;
	my $k;
	my @f;
	@names = split /\s+/, $fields;
	my $key = shift @names;
	my @set;
	my $i = 0;
	my $idx = 0;
	for(@names) {
		$db->column_index($_);
		$set[$idx++] = $db->field_settor($_);
	}
	my %keys;
	if ($opt->{cleanse}) {
		# record existing columns
		my $recs = $db->query("select $key from $table");
		$keys{$_->[0]} = 1 for @$recs;
	}
	my $count = 0;
	my $totcount = 0;
	my $delcount = 0;
	my $addcount = 0;
	while(<UPDATE>) {
		chomp;
		$totcount++;
		($k, @f) = split /$delimiter/o, $_;
		if(/^\f(\w+)$/) {
			$out .= "${tmsg}$count records processed of $totcount input lines.\n";
			$out .= "${tmsg}$delcount records deleted.\n" if $delcount;
			$out .= "${tmsg}$addcount records added.\n" if $addcount;
			$delcount = $totcount = $addcount = 0;
			$change_sub->($1);
			redo TABLE;
		}
		if(! $k and ! length($k)) {
			if ($f[0] eq 'DELETE') {
				next if ! $opt->{delete};
				$out .= "${tmsg}Deleting record '$f[1]'.\n" if $verbose;
				$db->delete_record($f[1]);
				$count++;
				$delcount++;
				next;
			}
		}
		$out .= "${tmsg}Record '$k' had too many fields, ignored.\n"
			if @f > $idx;
		if ( ! length($k) or ! $db->record_exists($k)) {
			if ($opt->{add}) {
				if( ! length($k) and ! $opt->{autonumber}) {
					$out .= "${tmsg}Blank key, no autonumber option, skipping.\n";
					next;
				}
				$k = $db->set_row($k);
				$out .= "${tmsg}Adding record '$k'.\n" if $verbose;
				$addcount++;
			}
			else {
				$out .= "${tmsg}Non-existent record '$k', skipping.\n";
				next;
			}
		}
		for ($i = 0; $i < $idx; $i++) {
			$set[$i]->($k, $f[$i]);
			if ($opt->{cleanse}) {
				delete $keys{$k};
			}
		}
		$count++;
	}
	if ($opt->{cleanse}) {
		# remove any record which hasn't updated
		for (keys(%keys)) {
			$db->delete_record($_);
			$delcount++;
		}
	}
	$out .= "${tmsg}$count records processed of $totcount input lines.\n";
	$out .= "${tmsg}$delcount records deleted.\n" if $delcount;
	$out .= "${tmsg}$addcount records added.\n" if $addcount;
  }
	$out .= "</PRE>";
	close UPDATE;
	if($opt->{'move'}) {
		my $ext = POSIX::strftime("%Y%m%d%H%M%S", localtime());
		rename $file, "$file.$ext"
			or die "rename $file --> $file.$ext: $!\n";
		if(	$opt->{dir}
			and (-d $opt->{dir} or File::Path::mkpath($opt->{dir}))
			and -w $opt->{dir}
			)
		{
			File::Copy::move("$file.$ext", $opt->{dir})
				or die "move $file.$ext --> $opt->{dir}: $!\n";
		}
	}
	return $out unless $quiet;
	return;
}
EOR

