# ADDRESS.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package ADDRESS;

use strict;
require DBLIB;

## =============================================================================
##  This file is the address functionality.  It's all local
##
## =============================================================================


## =============================================================================
##  ADDRESS
## =============================================================================
##  These are the avaliable functions
##
##  listall            returns arrayref of all customer id's
##  create             creates a new customer
##  delete             deletes a customer
##  get_info           returns all of the info for a specific customer
##  set_attr           allows setting of various customer attributes
##  verify_id          verifies legit address id

## =============================================================================
##  IMPLEMENTATIONS
## =============================================================================

## -----------------------------------------------------------------------------
##   func: listall
##   desc: lists all of the addresses
##  param: none
##    ret: arrayref to address id's
##  notes: this is probably more or less useless
## -----------------------------------------------------------------------------

sub listall {
    
    my $sqlstr = "select id from address";
    my $ref = DBLIB::db_fetchall_arrayref($sqlstr);

    return $ref;
}


## -----------------------------------------------------------------------------
##   func: create
##   desc: creates a new address
##  param: name, street1, street2, city, state, zip, country
##    ret: adress_id
##  notes: 
## -----------------------------------------------------------------------------

sub create {
    my ($name, $street1, $street2, $city, $state, $zip, $country) = @_;

    ## get next sequence
    my $id = DBLIB::seq_next_get("address_sq");

    my $sqlstr = "insert into address 
                  (id, name, street1, street2, city, state, zip, country)
                  values
                  ($id, '$name', '$street1', '$street2', '$city', '$state', '$zip', '$country')";

  DBLIB::db_do($sqlstr);
    
    return $id;
}


## -----------------------------------------------------------------------------
##   func: delete
##   desc: deletes an address
##  param: address_id
##    ret: 1/ undef
##  notes: don't do this
## -----------------------------------------------------------------------------

sub delete {
    my ($id) = @_;

    ## don't delete if there are any fk referencing it
    ## first check customer_address

    my $sqlstr = "select address_id from customer_address where address_id = $id";
    my $id_ref = DBLIB::db_fetchall_arrayref($sqlstr);

    ## return if not empty
    return undef if ($id_ref->[0][0]);
    
    ## now check shipment
    $sqlstr = "select id from shipment where address_id = $id";
    $id_ref = DBLIB::db_fetchall_arrayref($sqlstr);
    
    ## return if not empty
    return undef if ($id_ref->[0][0]); 
    
    ## delete the actual address
    $sqlstr = "delete from address where id = $id";
    
    DBLIB::db_do($sqlstr);

    return 1;
}

## -----------------------------------------------------------------------------
##   func: get_info
##   desc: returns info about address
##  param: address id
##    ret: name, street1, street2, city, state, zip, country
##  notes: 
## -----------------------------------------------------------------------------

sub get_info {
    my ($id) = @_;

    my $sqlstr = "select name, street1, street2, city, state, zip, country 
                  from address where id = $id";

    my @info = DBLIB::db_fetchrow_array($sqlstr);

    return @info;
}


## -----------------------------------------------------------------------------
##   func: set_attr
##   desc: sets attributes of the address
##  param: $id, %attr
##    ret: 1/ undef
##  notes: 
## -----------------------------------------------------------------------------

sub set_attr {
    my ($id, %attrs) = @_;
    
    ## create sqlstr
    my $sqlstr = "update address set ";
    
    my ($key, $val);

    foreach $key (keys(%attrs)) {
	$sqlstr .= "$key = '$attrs{$key}', ";
    }

    chop $sqlstr;
    chop $sqlstr;

    $sqlstr .= " where id = $id";

  DBLIB::db_do($sqlstr);

    return 1;
}


## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies avalable address id
##  param: address_id
##    ret: 1/ 0 
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
    return DBLIB::verify_id("id", "address", @_);
}


1;







