# AFFILIATES.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package AFFILIATES;

use strict;

require DBLIB;
require MILTON;
require KNAR;

#
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#  &affiliates_list_all
#  &affiliates_create
#  &affiliates_create_highlevel
#  &affiliates_delete
#  &affiliates_get_info
#  &affiliates_set_info
#  &affiliates_set_info_highlevel
#  &affiliates_generate_affiliate_url
#  &affiliates_increment_hits
#  &affiliates_increment_sales
#  &affiliates_reset_stats
#  &affiliates_get_label
#  &affiliates_subtract_bogus_order
#  &affiliates_verify_id
#

#
# =============================================================================
#
# returns two columns: affiliate_id and label
#

sub affiliates_list_all {
  my($sqlstr) = 'select affiliate_id,label
                 from affiliate
                 where affiliate_id <> 0
                 order by label';

  return(DBLIB::db_fetchall_arrayref($sqlstr));
}

#
# -----------------------------------------------------------------------------
#
# calls affiliates_create with some useful default values
#

sub affiliates_create_highlevel {
  my($label,$page,$delay) = @_;

  my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)
     = localtime(time);
  $year += 1900;
  $mon++;

  return(affiliates_create($label,$page,"",0,0,0,$delay,
         DBLIB::date_string_make($sec,$min,$hour,$mday,$mon,$year)));
}

#
# -----------------------------------------------------------------------------
#
#  notes: if affiliateurl is blank or undefined, the function 
#         affiliate_generate_affiliate_url is called to generate one
#         automatically
#

sub affiliates_create {
  my($label, $durl, $aurl, $hits, $sales, $dollars, $expire, $reset) = @_;

  # get the next template id
  
  my($next_affiliate_id) = DBLIB::seq_next_get('affiliate_sq');

  if (!defined($aurl) || $aurl eq "") {
    $aurl = affiliates_generate_affiliate_url($next_affiliate_id);
  }

  # create the template

  my($sqlstr) = "insert into affiliate (affiliate_id, label, defaulturl,
                 affiliateurl, hits, sales, salesdollars, expiredelay,
                 resetdate) 
                 values
                 ('$next_affiliate_id', '$label', '$durl', '$aurl', '$hits',
                 '$sales', '$dollars', '$expire', $reset)";

  DBLIB::db_do($sqlstr);

  return($next_affiliate_id);  
}

#
# -----------------------------------------------------------------------------
#

sub affiliates_delete {
  my($affiliateid) = shift;
  my($sqlstr) = "delete from affiliate where affiliate_id = '$affiliateid'";
  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#
# Returns $label,$durl,$aurl,$hits,$sales,$dollars,$expire,$reset
#

sub affiliates_get_info {
  my($aid) = shift;

  my($sqlstr) = "select label,defaulturl,affiliateurl,hits,sales,salesdollars,
                 expiredelay,resetdate
                 from affiliate where affiliate_id = '$aid'";

  return(DBLIB::db_fetchrow_array($sqlstr));
}

#
# -----------------------------------------------------------------------------
#

sub affiliates_set_info {
  my($aid,$label,$durl,$aurl,$hits,$sales,$dollars,$expire,$reset) = @_;

  my($sqlstr) = "update affiliate
                 set label='$label', defaulturl='$durl', affiliateurl='$aurl',
                 hits='$hits', sales='$sales', salesdollars='$dollars',
                 expiredelay='$expire', resetdate='$reset'
                 where affiliate_id = '$aid'";

  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#

sub affiliates_set_info_highlevel {
  my($aid, $label, $durl, $expire) = @_;

  my($sqlstr) = "update affiliate
                 set label='$label', defaulturl='$durl', expiredelay='$expire'
                 where affiliate_id = '$aid'";

  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#

sub affiliates_generate_affiliate_url {
  my($aid) = shift;
  my($url) = KNAR::knar_entry_get('TALLYMAN_URL');
  return("$url/aroute.epl?aid=$aid");
}


#
# -----------------------------------------------------------------------------
#
# XXX this function is deprecated.  See the new ORDERSTATS module!
#

sub affiliates_increment_hits {
  my($aid) = shift;
  
  my($sqlstr) = "update affiliate
                 set hits=hits+1
                 where affiliate_id = '$aid'";

  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#
# XXX this function is deprecated.  See the new ORDERSTATS module!
#

sub affiliates_increment_sales {
  my($aid,$dollars) = @_;
  
  my($sqlstr) = "update affiliate
                 set sales=sales+1,salesdollars=salesdollars+'$dollars'
                 where affiliate_id='$aid'";

  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#
# XXX this function is deprecated.  See the new ORDERSTATS module!
#

sub affiliates_reset_stats {
  my($aid) = shift;
  
  my($sqlstr) = "update affiliate
                 set sales=0,hits=0,salesdollars=0
                 where affiliate_id='$aid'";

  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#
# Returns the label
#

sub affiliates_get_label {
  my($aid) = shift;
  my($sqlstr) = "select label from affiliate where affiliate_id = '$aid'";
  my($label) = DBLIB::db_fetchrow_array($sqlstr);
  return($label);
}

#
# -----------------------------------------------------------------------------
#
# XXX this function is deprecated.  See the new ORDERSTATS module!
#

sub affiliates_subtract_bogus_order {
  my($affiliate_id,$total) = @_;

  my($sqlstr) = "update affiliate
                 set sales=sales-1, salesdollars=salesdollars-'$total'
                 where affiliate_id = '$affiliate_id'";

  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#

sub affiliates_verify_id {
  return DBLIB::verify_id('affiliate_id', 'affiliate', @_);
}

#
# -----------------------------------------------------------------------------
#

1;
