# CONFIG.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package CONFIG;

use strict;
require MILTON;
require SEC;

# 
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#   &get_entry
#   &load_configuration
#   &save_configuration
#

my $config_loaded = 0;
my %Configuration;
my $current_storeid = '';

#
# -----------------------------------------------------------------------------
#

sub get_entry {
  my($key) = shift;

  if (!$config_loaded) {
    load_configuration();
  }

  if ($ENV{'TALLYMAN_SID'} ne $current_storeid) {
    load_configuration();
  }

  if (!defined($Configuration{$key})) {
    MILTON::fatal_error("Invalid configuration token requested: $key");
  }

  return $Configuration{$key};
}

#
# -----------------------------------------------------------------------------
#

sub load_configuration {
  my($key, $value, $i, $cfile_path);

  # load file

  $current_storeid = $ENV{'TALLYMAN_SID'};
  SEC::untaint_ref(\$current_storeid);

  $cfile_path = "$ENV{'TALLYMAN_PATH'}/stores/$ENV{'TALLYMAN_SID'}/configuration";
  SEC::untaint_ref(\$cfile_path);

  open(CONFIG, $cfile_path)
    || MILTON::fatal_error("Can't find config file: $cfile_path");

  while (<CONFIG>) {
    next if /^#/; # Ignore comments
    chomp;
    ($key,$value) = split/: /,$_,2;
    SEC::untaint_ref(\$key);
    SEC::untaint_ref(\$value);
    $Configuration{$key} = $value;
  }

  close CONFIG;

  $config_loaded = 1;
}

#
# -----------------------------------------------------------------------------
#

sub save_configuration {
  my ($i, $cfile_path);

  # open file

  $cfile_path = "$ENV{'TALLYMAN_PATH'}/stores/$ENV{'TALLYMAN_SID'}/configuration";
  SEC::untaint_ref(\$cfile_path);

  open(CONFIG,">$cfile_path")
    || MILTON::fatal_error("Can't open config file for writing: $cfile_path");

  foreach $i (keys(%Configuration)) {
    print CONFIG "$i: $Configuration{$i}\n";
  }

  close CONFIG; 
}

#
# -----------------------------------------------------------------------------
#

1;





