# DBUTIL.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

# Skeleton library.  Does nothing as yet.

package DBUTIL;

use strict;

require MILTON;
require DBLIB;

#
# 
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
# &show_items_with_no_stockid_or_mixid
# &show_items_not_in_any_container
# &resequence_all_subproducts
# &verify_referential_integrity
# &find_lost_data_chunks
# &find_cross_linked_mixes
#
# =============================================================================
#

#
# -----------------------------------------------------------------------------
#
# returns a list of items for which both the stock_id and the mix_id are 0
#
#   takes: nothing
# returns: $array_ref (item_id, label)
#

sub show_items_with_no_stockid_or_mixid {
}

#
# -----------------------------------------------------------------------------
#
# returns a list of all items not in any container
#
#   takes: nothing
# returns: \@item_id, \@label
#

sub show_items_not_in_any_container {
}

#
# -----------------------------------------------------------------------------
#
# corrects the sequence_number of the container tree
#
#   takes: nothing
# returns: nothing
#

sub resequence_all_subproducts {
}

#
# -----------------------------------------------------------------------------
#
# verifies that all foreign keys reference existing data
# (this is really only useful for databases which don't implement any kind
# of referential integrity checking)
# returns a list of items in violation
#
#   takes: nothing
# returns: $array_ref (table_name, id)
#

sub verify_referential_integrity {
}

#
# -----------------------------------------------------------------------------
#
# Occasionally, chunks of data will exist which aren't associated with what
# they're supposed to be.  For example, an address shouldn't ever exist in
# the address table alone -- it's meant to be referenced by an order.  If an
# entry in the address table _isn't_ referenced by an order, it'll stay there
# forever, and never be used.  It is, in essence, "lost."  This routine
# finds it.  (...I suppose I could have called it the "ninety and nine"
# subroutine...)
#
#   takes: nothing
# returns: $array_ref (table_name, it)
#

sub find_lost_data_chunks {
  # There is no generalized routine for this, so we have to do it for each
  # table individually.

  # stock       no item or cell
  # snip        no item_snip
  # range
  # node        cell_id !=0, range_id !=0
  # cell        mix_id !=0, stock_id !=0
  # mix

  

}

#
# -----------------------------------------------------------------------------
#
# An item can be a mixed item.  That mix should have nodes which point to
# ranges that all exist within a single matrix.  In other words, a mix
# should never "span" matrices.  That's one way that a mix can be invalid.
#
# The other way is if a cell has multiple nodes pointing to multiple ranges
# that are all within the same dimension.  That is, an item should never
# have more than one value selected for any given dimension.
#

sub find_invalid_mixes {
}

#
# -----------------------------------------------------------------------------
#


1;

