# DISCOUNT.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package DISCOUNT;

use strict;
require DBLIB;


## =============================================================================
##  This file is the tax functionality.  It's all local
##
## =============================================================================


## =============================================================================
##  DISCOUNT
## =============================================================================
##  These are the avaliable functions
##
##  listall            returns arrayref of all customer id's
##  create             creates a new customer
##  delete             deletes a customer
##  get_info           returns all of the info for a specific customer
##  set_attr           allows setting of various customer attributes
##  verify_id          verfies legit discount id

## =============================================================================
##  IMPLEMENTATIONS
## =============================================================================

## -----------------------------------------------------------------------------
##   func: listall
##   desc: lists all of the dsicounts
##  param: none
##    ret: arrayref of tax id's
##  notes: more or less useless
## -----------------------------------------------------------------------------

sub listall {
    
    my $sqlstr = "select id, label, amnt from discount";
    my $ref = DBLIB::db_fetchall_arrayref($sqlstr);

    return $ref;
}


## -----------------------------------------------------------------------------
##   func: create
##   desc: creates a new discount
##  param: type_label, amnt
##    ret: tax_id
##  notes: 
## -----------------------------------------------------------------------------

sub create {
    my ($type_label, $amnt) = @_;

    ## get next sequence
    my $id = DBLIB::seq_next_get("tax_sq");

    my $sqlstr = "insert into discount
                  (id, label, amnt)
                  values
                  ($id, '$type_label', $amnt)";

  DBLIB::db_do($sqlstr);
    
    return $id;
}


## -----------------------------------------------------------------------------
##   func: delete
##   desc: deletes a discount
##  param: discount_id
##    ret: 1/ undef
##  notes: don't do this
## -----------------------------------------------------------------------------

sub delete {
    my ($id) = @_;

    DBLIB::db_transact_begin();

    ## clean up any fk in tax
    my $sqlstr = "delete from orderline_discount where discount_id = $id";
    DBLIB::db_do($sqlstr);

    $sqlstr = "delete from cat_order_discount where discount_id = $id";
    DBLIB::db_do($sqlstr);
    
    ## delete the actual tax
    $sqlstr = "delete from discount where id = $id";

    DBLIB::db_do($sqlstr);

    DBLIB::db_transact_end();

    return 1;
}

## -----------------------------------------------------------------------------
##   func: get_info
##   desc: returns info about discount
##  param: discount_id
##    ret: type_label, amnt
##  notes: 
## -----------------------------------------------------------------------------

sub get_info {
    my ($id) = @_;

    my $sqlstr = "select label, amnt 
                  from discount where id = $id";

    my @info = DBLIB::db_fetchrow_array($sqlstr);

    return @info;
}


## -----------------------------------------------------------------------------
##   func: set_attr
##   desc: sets attributes of the discount
##  param: $id, %attr
##    ret: 1/ undef
##  notes: 
## -----------------------------------------------------------------------------

sub set_attr {
    my ($id, %attrs) = @_;
    
    ## create sqlstr
    my $sqlstr = "update discount set ";
    
    my ($key, $val);

    foreach $key (keys(%attrs)) {
	$sqlstr .= "$key = '$attrs{$key}', ";
    }

    chop $sqlstr;
    chop $sqlstr;

    $sqlstr .= " where id = $id";

  DBLIB::db_do($sqlstr);

    return 1;
}


## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies avalable discount id
##  param: discount_id
##    ret: 1/ 0 
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
    return DBLIB::verify_id("id", "discount", @_);
}


1;




