# GROUP.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package GROUP;

use strict;

require DBLIB;
require THINGTYPE;
require CONTAINER;

#
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#		    &group_list_all
#		    &group_find_by_name
#		    &group_create
#		    &group_delete
#                   &group_get_label
#                   &group_get_id
#                   &group_set_label
#                   &group_verify_id
#
# =============================================================================
#

sub group_list_all {

  my($rows) = DBLIB::db_fetchall_arrayref("
    select group_id, name
    from group_table
    where group_id <> 0
    order by name");

  return($rows); 
}

#
# -----------------------------------------------------------------------------
#

sub group_find_by_name {
  my($label, $command, @ids) = @_;
  my($column, $op, $sqlstr, $ids_str);

  $column = "name";
  if ($command =~ /i/) {
    $label =~ tr/A-Z/a-z/;
    $column = "lower(name)";
  }

  # XXX hmmm. does 'like' work for databases other than oracle???

  $op = " = '$label'";
  if ($command =~ /s/) {
    $op = " like '%$label%'";
  }
  $sqlstr = "select group_id, name
             from group_table 
             where $column $op";

  if ($#ids > -1) {
    my $ids_str = join(",", @ids);
    $sqlstr .= " and group_id in ($ids_str)";
  }

  return(DBLIB::db_fetchall_arrayref($sqlstr));

}

#
# -----------------------------------------------------------------------------
#

sub group_create {
  my($name, $type_id)=@_;

  # get the next group id
  
  my($nextgroupid)= DBLIB::seq_next_get("group_sq");

  # create the group

  DBLIB::db_do("insert into group_table (group_id,name) values
           ('$nextgroupid','$name')");

  # Add to the connecting table, so we know what type we are.
  THINGTYPE::thingtype_add_thing($THING::group, $type_id, $nextgroupid);

  return($nextgroupid);  
}

#
# -----------------------------------------------------------------------------
#

sub group_set_label {
  my($group_id, $name)=@_;

  # verify the group's existance
  my($check_id) =       DBLIB::db_fetchrow_array("select group_id 
                              from group_table where
                              group_id = $group_id");

  MILTON::fatal_error("Nonexistant group $group_id") unless($check_id 
							    == $group_id);

  # update the group

  DBLIB::db_do("
      update group_table 
      set name = '$name'
      where group_id = $group_id");

  return 1;
}

#
# -----------------------------------------------------------------------------
#

sub group_delete {
  my($groupid) = @_;

  # Find and delete the group anywhere it appears in the container system
  my($rowlistref) = CONTAINER::container_find($THING::group, $groupid);

  my($row);
  foreach $row (@$rowlistref) {
      CONTAINER::container_delete($row);
  }

  # delete all the snippets
  SNIPPET::snip_delete_all($THING::group, $groupid);

  # delete from the container<->type table
  THINGTYPE::thingtype_delete_thing_to_type($THING::group, $groupid);

  # delete the actual group.
  DBLIB::db_do("delete from group_table where group_id = '$groupid'");
}

#
# -----------------------------------------------------------------------------
#

sub group_get_label {
  my($groupid)=@_;

  my($label)=DBLIB::db_fetchrow_array(
          "select name from group_table where group_id = ?",
				      0, $groupid, 1);

  return($label);
}

#
# -----------------------------------------------------------------------------
# Given a group name, returns its id.

sub group_get_id {
  my($group_name)=@_;

  my($id) =DBLIB::db_fetchrow_array(
          "select group_id from group_table where name = ?",0
				    , $group_name, 0);

  return $id;
}

#
# -----------------------------------------------------------------------------
#

sub group_set_info {
  my($gid,$name,$tid)=@_;

  DBLIB::db_do("update group_table
               set name='$name', template_id='$tid'
               where group_id='$gid'");
}

#
# -----------------------------------------------------------------------------
#

sub group_set_attr {
  my($gid, %vals) = @_;
  my($str, $key, @vkeys);

  @vkeys = keys(%vals);
  if ($#vkeys < 0) {
    return;
  }

  $str = "update group_table set ";
  foreach $key (@vkeys) {
    $str .= "$key='$vals{'$key'}', ";
  }
  chop $str;
  chop $str;

  $str .= " where group_id = '$gid'";

  DBLIB::db_do($str);
}

#
# -----------------------------------------------------------------------------


sub group_verify_id {
  return DBLIB::verify_id('group_id', 'group_table', @_);
}

#
# -----------------------------------------------------------------------------
#

1;




