# LAYEX.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

# The layout exporter

package LAYEX;

use strict;
use DBLIB;
use THING;
use ITEM;
use PAGE;
use GROUP;
use CONTAINER;

#
# -----------------------------------------------------------------------------
#

sub layout_export {
  my($fname);

  $fname = "$ENV{'TALLYMAN_PATH'}/stores/$ENV{'TALLYMAN_SID'}/tmp/layoutdownload.txt";
  SEC::untaint_ref(\$fname);

  if (!open(EXPORTFH, ">$fname")) {
    return (0, "Could not open $fname: $!");
  }

  layex_recurse(0, 0);

  close(EXPORTFH);

  return (1, "Whoohoo!");
}

#
# -----------------------------------------------------------------------------
#

sub layex_recurse {
  my($cid, $level) = @_;
  my($children, $child);
  my($p_cid, $seq_no, $type, $thing_id);

  $children = CONTAINER::container_children_cid($cid);

  print_space($level);

  if ($cid != 0) {
    ($p_cid, $seq_no, $type, $thing_id) = CONTAINER::container_info($cid);
    if ($type eq $THING::item) {
      print EXPORTFH "!I!";
    } elsif ($type eq $THING::page) {
      print EXPORTFH "!P!";
    } elsif ($type eq $THING::group) {
      print EXPORTFH "!G!";
    }
  }

  print EXPORTFH get_name($cid) . "\n";

  foreach $child (@$children) { 
    layex_recurse($child, $level+1);
  }

}

#
# -----------------------------------------------------------------------------
#

sub print_space {
  my($level) = shift;
  my($i);
  for ($i=0; $i<$level; $i++) {
    print EXPORTFH "  ";
  }
}

#
# -----------------------------------------------------------------------------
#

sub get_name {
  my($cid) = shift;
  if ($cid eq "0") {
    return '!ROOT!';
  } else {
    return CONTAINER::container_thing_name($cid);
  }
}


1;
