# MILTON.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package MILTON;

use strict;

require DBLIB;
require SEC;
require KNAR;

# 
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#   &fatal_error
#   &html_fatal_error
#   &auth_error
#   &url_escape
#   &set_error_handler
#   &swrite
#   &redirect
#   &gen_html_header
#   &gen_html_footer
#   &show_cgi_data
#
#   &milton_universal_header
#   &milton_universal_footer
#   &milton_get_toolbar
#
#   &milton_get_color1
#   &milton_get_color2
#   &milton_get_color3
#   &milton_get_color4
#   &milton_get_titlebartextcolor
#   &milton_get_errorcolor
#
#   &milton_get_bgcolor
#   &milton_get_textcolor
#   &milton_get_linkcolor
#   &milton_get_alinkcolor
#   &milton_get_vlinkcolor
#
#   &generic_call
#

## make vars package specific

use vars qw($offline_mode $basket_cookie_name $err_func);

# Stuff relating to offline mode
$offline_mode = ($ENV{MOD_PERL} ? 0: 1);

$basket_cookie_name = "SHOPPING_BASKET"; # Name of the cookie for STATE.pm
                                 # to set to store shopping basket info.
                                 # Used in BASKET.pm
$err_func = \&html_fatal_error;

BEGIN {

    # Make it global so it'll be visible outside the BEGIN {}
    use vars qw($ugly_fatals $sure_exit);

    # Show a stack backtrace on fatal error via CGI::Carp?
    $ugly_fatals = 1;
    sub set_ugly_fatals { $ugly_fatals = $_[0]; };

    # With this enabled, do a "kill 9, 0" of myself on a fatal error.
    # Use this if you have problems with TallyMan hanging on fatals.
    # Otherwise, we call $offline_mode ? exit() : Apache->exit().
    $sure_exit = 0;
    sub set_sure_exit { $sure_exit = $_[0]; };

    if($ugly_fatals) {
	require CGI::Carp;
	import CGI::Carp qw(fatalsToBrowser);
	$Carp::MaxArgLen = 0;
	$Carp::MaxArgNums = 0;
    }
}

sub offline_mode { return $offline_mode; };
sub basket_cookie_name { return $basket_cookie_name; };
sub template_dir { 
    return "$ENV{'TALLYMAN_PATH'}/stores/$ENV{'TALLYMAN_SID'}/templates"; 
}

#
# =============================================================================
#
# UTILITY FUNCTIONS
#
# =============================================================================
#

#
# -----------------------------------------------------------------------------
#
# prints out a pretty fatal error message
#

sub fatal_error {
  if (!defined($err_func) || ref($err_func) ne 'CODE') {
    html_fatal_error(@_);
  } else {
    &$err_func(@_);
  }
}

sub html_fatal_error {
  my($msg) = shift;
  my($i);
  $| = 1;

  # This is a little ugly, but might be important if we're dying
  # before the header is even printed.
  print STDOUT "Content-type: text/html\n\n";
  print STDOUT "<html><head><title>TallyMan Fatal Error</title></head>\n";
  print STDOUT "<body bgcolor=\"#ffffff\" fgcolor=\"#000000\">\n";

  my($elog)="$ENV{'TALLYMAN_PATH'}/stores/$ENV{'TALLYMAN_SID'}/logs/error_log";
  SEC::untaint_ref(\$elog);

  DBLIB::db_cleanup();

  if (open(ERRORLOG,">>$elog")) {
    chmod 0600, $elog;
    my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
    print ERRORLOG "$mday/$mon/$year $hour:$min:$sec $msg\n";
    foreach $i (sort(keys(%HTML::Embperl::fdat))) {
      if ($HTML::Embperl::fdat{$i} =~ /\0/) {
        print ERRORLOG "[$i] = [", join(" ",split(/\0/,$HTML::Embperl::fdat{$i})), "]\n";
      } else {
        print ERRORLOG "[$i] = [$HTML::Embperl::fdat{$i}]\n";
      }
    }
    close(ERRORLOG);
  } else {
    print STDOUT "\nCan't open error_log!<br>\n";
  }

  if($ugly_fatals) {
      print STDOUT "TallyMan Internal error:<font color=red>$msg.</font>\n";
      print STDOUT "<hr>\nDetails:<br>\n";
      print STDOUT "<plaintext>\n";
      print STDOUT longmess("Error");
  } else {

      gen_html_header_stdout("Fatal Error!");
      print STDOUT "<h3>Fatal Error!</h3><p><b>\n$msg\n</b><p><hr><p>\n";
      print STDOUT "<b>CGI data:</b><p>\n";  
      show_cgi_data_stdout();
      gen_html_footer_stdout();
  }

  kill(9, 0) if $sure_exit; # Yes, we really do want to exit.

  if($offline_mode) {
      exit 0;
  } else {
      require Apache;
      Apache->exit(0);
  }
}

# Stolen from Carp.pm
#
# longmess() crawls all the way up the stack reporting on all the function
# calls made.  The error string, $error, is originally constructed from the
# arguments passed into longmess() via confess(), cluck() or shortmess().
# This gets appended with the stack trace messages which are generated for
# each function call on the stack.

sub longmess {
    my $error = join '', @_;
    my $mess = "";
    my $i = 1;
    my ($pack,$file,$line,$sub,$hargs,$eval,$require);
    my (@a);
    #
    # crawl up the stack....
    #
    while (do { { package DB; @a = caller($i++) } } ) {
	# get copies of the variables returned from caller()
	($pack,$file,$line,$sub,$hargs,undef,$eval,$require) = @a;
	#
	# if the $error error string is newline terminated then it
	# is copied into $mess.  Otherwise, $mess gets set (at the end of
	# the 'else {' section below) to one of two things.  The first time
	# through, it is set to the "$error at $file line $line" message.
	# $error is then set to 'called' which triggers subsequent loop
	# iterations to append $sub to $mess before appending the "$error
	# at $file line $line" which now actually reads "called at $file line
	# $line".  Thus, the stack trace message is constructed:
	#
	#        first time: $mess  = $error at $file line $line
	#  subsequent times: $mess .= $sub $error at $file line $line
	#                                  ^^^^^^
	#                                 "called"
	if ($error =~ m/\n$/) {
	    $mess .= $error;
	} else {
	    # Build a string, $sub, which names the sub-routine called.
	    # This may also be "require ...", "eval '...' or "eval {...}"
	    if (defined $eval) {
		if ($require) {
		    $sub = "require $eval";
		} else {
		    $eval =~ s/([\\\'])/\\$1/g;
#		    if ($MaxEvalLen && length($eval) > $MaxEvalLen) {
#			substr($eval,$MaxEvalLen) = '...';
#		    }
		    $sub = "eval '$eval'";
		}
	    } elsif ($sub eq '(eval)') {
		$sub = 'eval {...}';
	    }
	    # if there are any arguments in the sub-routine call, format
	    # them according to the format variables defined earlier in
	    # this file and join them onto the $sub sub-routine string
	    if ($hargs) {
		# we may trash some of the args so we take a copy
		@a = @DB::args;	# must get local copy of args
		# don't print any more than $MaxArgNums
#		if ($MaxArgNums and @a > $MaxArgNums) {
#		    # cap the length of $#a and set the last element to '...'
#		    $#a = $MaxArgNums;
#		    $a[$#a] = "...";
#		}
		for (@a) {
		    # set args to the string "undef" if undefined
		    $_ = "undef", next unless defined $_;
		    if (ref $_) {
			# dunno what this is for...
			$_ .= '';
			s/'/\\'/g;
		    }
		    else {
			s/'/\\'/g;
			# terminate the string early with '...' if too long
#			substr($_,$MaxArgLen) = '...'
#			    if $MaxArgLen and $MaxArgLen < length;
		    }
		    # 'quote' arg unless it looks like a number
		    $_ = "'$_'" unless /^-?[\d.]+$/;
		    # print high-end chars as 'M-<char>' or '^<char>'
		    s/([\200-\377])/sprintf("M-%c",ord($1)&0177)/eg;
		    s/([\0-\37\177])/sprintf("^%c",ord($1)^64)/eg;
		}
		# append ('all', 'the', 'arguments') to the $sub string
		$sub .= '(' . join(', ', @a) . ')';
	    }
	    # here's where the error message, $mess, gets constructed
	    $mess .= "\t$sub " if $error eq "called";
	    $mess .= "$error at $file line $line\n";
	}
	# we don't need to print the actual error message again so we can
	# change this to "called" so that the string "$error at $file line
	# $line" makes sense as "called at $file line $line".
	$error = "called";
    }
    # this kludge circumvents die's incorrect handling of NUL
    my $msg = \($mess || $error);
    $$msg =~ tr/\0//d;
    $$msg;
}


#
# -----------------------------------------------------------------------------
#

sub set_error_handler {
  my($func) = shift;
  if (ref($func) eq 'CODE') {
    $err_func = $func;
  }
}

#
# -----------------------------------------------------------------------------
#
# prints out a pretty authorization error message
#

sub auth_error {
  my($msg) = shift;
  $msg = SEC::encode_uri($msg);
  redirect("autherr.epl?msg=$msg");
}

#
# -----------------------------------------------------------------------------
#

#
# -----------------------------------------------------------------------------
#
# shows all CGI data passed in
#

sub show_cgi_data {
  my($i);

  print OUT "\n<pre>";
  foreach $i (keys(%HTML::Embperl::fdat)) {
    if ($HTML::Embperl::fdat{$i} =~ /\0/) {
      print OUT "[$i] = [", join(" ",split(/\0/,$HTML::Embperl::fdat{$i})), "]\n";
    } else {
      print OUT "[$i] = [$HTML::Embperl::fdat{$i}]\n";
    }
  }
  print OUT "</pre>\n";
}

sub show_cgi_data_stdout {
  my($i);

  print STDOUT "\n<pre>";
  foreach $i (keys(%HTML::Embperl::fdat)) {
    if ($HTML::Embperl::fdat{$i} =~ /\0/) {
      print STDOUT "[$i] = [", join(" ",split(/\0/,$HTML::Embperl::fdat{$i})), "]\n";
    } else {
      print STDOUT "[$i] = [$HTML::Embperl::fdat{$i}]\n";
    }
  }
  print STDOUT "</pre>\n";
}

#
# =============================================================================
#
# MISCELLANEOUS FUNCTIONS
#
# =============================================================================
#

## ----------------------------------------------------------------------------
##   func: generic_call
##   desc: OK, this one is kind of cute. It calls a code reference from a hash
##         that is passed to it.  The key to the hash is in some configuration
##         thing somewhere.  For now, it is just "LOCAL"
##  param: hash, params
##    ret: whatever the code ref returns
##  notes:
## ----------------------------------------------------------------------------

sub generic_call {
    my ($hash_ref, @params) = @_;
    return &{$$hash_ref{"LOCAL"}}(@params);
}

# stolen from the perlform man page.  Thanks, guys!

sub swrite {
  my $format = shift;
  $^A = "";
  formline($format,@_);
  return $^A;
}

# Use with care!  Very much a hack when used in offline mode! 
# A better solution hopefully will be forthcoming, but until then,
# make sure nothing (or as little as possible) is printed to STDOUT 
# before calling this function.
# 
# If passed just one parm, redirect there.  If a cookie_name and cookie_value
# are passed (and we're in offline mode), send a Set-Cookie header as well.
# You're responsible for URI-escaping the cookie name/value.
#

sub redirect {
  my($url, $cookie_name, $cookie_val) = @_;

  my($header);
  $header = "Status: 302\n";
  $header .= "Location: $url\n";
#  $header .= "URI: $url\n";

  if ($cookie_name) {
    # Should there be a ; here?
    $header .= "Set-Cookie: $cookie_name=$cookie_val\n";
  }
      
  $header .= "\n";

#  open (HOHUM, ">>/tmp/hohum");
#  print HOHUM $header . "\n\n";
#  close (HOHUM);

  if ($offline_mode) {
      syswrite(STDOUT, $header, length($header));
      exit(0);

  } else {
      require Apache;
      my $r = Apache->request;
      $r->status(302);
      
      $r->send_cgi_header($header);
      $r->send_http_header;
      Apache->exit(0);
  }
}

sub gen_html_header {
  my($title) = shift || "Milton";
  print OUT 
"<html>
<head><title>$title</title></head><body bgcolor=\"#ffffff\">\n";
}

sub gen_html_footer {
  print OUT "</body>\n</html>\n";
}

sub gen_html_header_stdout {
  my($title) = shift || "Milton";
  print STDOUT "<html><head><title>$title</title></head><body bgcolor=\"#ffffff\">\n";
}

sub gen_html_footer_stdout {
  print STDOUT "</body>\n</html>\n";
}

#
# -----------------------------------------------------------------------------
#


sub milton_get_color1 {
  return KNAR::knar_entry_get('MILTON_COLOR1') || "#ffffcc";
}

sub milton_get_color2 {
  return KNAR::knar_entry_get('MILTON_COLOR2') || "#cccc99";
}

sub milton_get_color3 {
  return KNAR::knar_entry_get('MILTON_COLOR3') || "#666633";
}

sub milton_get_color4 {
  return KNAR::knar_entry_get('MILTON_COLOR4') || "#336699";
}

sub milton_get_titlebartextcolor {
  return KNAR::knar_entry_get('MILTON_TITLEBARTEXTCOLOR') || "#cccccc";
}

sub milton_get_image {
  return KNAR::knar_entry_get('MILTON_IMAGE') || "images/tan_logo.gif";
}

sub milton_get_errorcolor {
  return KNAR::knar_entry_get('MILTON_ERRORCOLOR') || "#ffeeee";
}

sub milton_get_bgcolor {
  return KNAR::knar_entry_get('MILTON_BGCOLOR') || "#ffffcc";
}

sub milton_get_textcolor {
  return KNAR::knar_entry_get('MILTON_TEXTCOLOR') || "#333333";
}

sub milton_get_linkcolor {
  return KNAR::knar_entry_get('MILTON_LINKCOLOR') || "#000000";
}

sub milton_get_alinkcolor {
  return KNAR::knar_entry_get('MILTON_ALINKCOLOR') || "#000000";
}

sub milton_get_vlinkcolor {
  return KNAR::knar_entry_get('MILTON_VLINKCOLOR') || "#000000";
}

sub milton_get_bodytag {
  return "<body bgcolor=\"" . milton_get_bgcolor() .
         "\" link=\"" . milton_get_linkcolor() .
         "\" alink=\"" . milton_get_alinkcolor() .
         "\" vlink=\"" . milton_get_vlinkcolor() .
         "\">";
}

#
# -----------------------------------------------------------------------------
#
# boxes?
# warnings?
# errors?

sub milton_universal_header {
  my ($title) = shift;
  my ($masthead) = shift;
  my ($image) = shift;
  my ($help_url) = shift;
  my ($timename) = time;
  my ($order_url);

  $order_url = KNAR::knar_entry_get('ADMIN_SECURE_URL') . '/order.epl'; 

  my ($ref) = $ENV{'SCRIPT_NAME'};
  my ($str) = <<EOTEXT;
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=iso-8859-1">
<title>
$title
</title>
<style type="text/css">
<!--
 a:active { text-decoration: none }
 a:link { text-decoration: none }
 a:visited { text-decoration: none }
  -->
</style>

<script language="JavaScript1.2">
<!--

function open_help(url) {
  opts="top=0,left=0,scrollbars,location=no,status=no,toolbar=no,resizable,fullsize=no,width=630,height=480";
  window.open(url, 'Help', opts);
}

function open_quicklinks() {
  window.name = "mainwindow$timename";
  opts="top=0,left=0,scrollbars,location=no,status=no,toolbar=no,resizable,fullsize=no,width=120,height=470";
  window.open('quicklinks.epl?win=$timename', 'Quicklinks$timename', opts);
}

// -->
</script>

</head>
EOTEXT

  $str .= milton_get_bodytag();

  $str .= <<EOTEXT;

<!-- ----- BEGIN TITLEBAR ----- -->

<table width="100%" height="22" 
 bgcolor="@{[MILTON::milton_get_color4()]}" border="0" cellpadding="0" 
 cellspacing="0">

<tr height="22">
<td width="12" align="left" valign="top" height="22"><img src="images/curve_left.gif" width="12" height="22"></td>

<td valign="middle" height="22">

<img src="images/cleardot.gif" width="12">

<a href="$order_url">
<img src="images/icon_orders.gif" height="16" width="16" border="0" 
 align="top">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
 &nbsp;Orders
</font></a>

<img src="images/cleardot.gif" width="12">

<a href="page.epl">
<img src="images/icon_pages.gif" height="16" width="16" border="0" align="top">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
&nbsp;Pages
</font></a>

<img src="images/cleardot.gif" width="12">

<a href="item.epl">
<img src="images/icon_item.gif" height="16" width="16" border="0" align="top">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
&nbsp;Items
</font></a>

<img src="images/cleardot.gif" width="12">

<a href="genconfig.epl">
<img src="images/icon_config.gif" height="16" width="16" border="0" 
 align="top">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
&nbsp;Configure
</font></a>

<img src="images/cleardot.gif" width="12">

<a href="genstats.epl">
<img src="images/icon_stats.gif" height="16" width="16" border="0" align="top">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
&nbsp;Statistics
</font></a>

<img src="images/cleardot.gif" width="12">

<a href="regen.epl">
<img src="images/icon_regen.gif" height="16" width="16" border="0" align="top">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
&nbsp;Regenerate
</font></a>

<img src="images/cleardot.gif" width="12">
</td>

<td align="right" valign="middle" height="22">
<a href="javascript:open_quicklinks()">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
Quicklinks
</font>
</a>

<a href="javascript:open_help('http://www.tallyman.com/help/beta/${help_url}')">
<font face="Verdana,Arial,Helvetica,sans-serif" size="2"
 color="@{[MILTON::milton_get_titlebartextcolor()]}">
Help
</font></a>
</td>

<td width="12" align="right" valign="top" height="22"><img src="images/curve_right.gif" border="0" width="12" height="22"></td>

</tr>
</table>

<!-- ----- END TITLEBAR ----- -->

<p>

<center>
<table cellpadding="0" cellspacing="0">
<tr>
<td colspan=2><br>
<img src="images/$image" width=16 height="16" border="0" valign="top" align="top">
EOTEXT

  $str .= "
&nbsp;
<font size=\"+1\" face=\"Verdana,arial,helvetica,sans-serif\" color=\""

  . milton_get_textcolor() . "\">
$masthead
<p>
&nbsp;
</font>
</td>
</tr>

<tr>
<td colspan=\"2\">

<!-- ----- BEGIN REAL STUFF ----- -->
";

  return($str);
}

#
# -----------------------------------------------------------------------------
#

sub milton_universal_footer {
  my($str);

  $str = <<EOTEXT;

<!-- ----- END REAL STUFF ----- -->

</td>
</tr>

<tr>
<td colspan=2>
<p>
&nbsp;
<p>
&nbsp;
<p>
</tr>

<tr>
<td colspan="2">
<hr noshade size="2" width="100%">
</td>
</tr>
<tr>
<td valign=top>
<a href="http://www.tallyman.com"><font face="Verdana,Arial,Helvetica,sans-serif" size="1"><b>Tallyman</b></font></a><font face="Verdana,Arial,Helvetica,sans-serif" size="1"><b> - &copy;1999 <a href="http://www.akopia.com/">Akopia, Inc.</a> &nbsp; &nbsp; &nbsp; &nbsp; Username: $ENV{'REMOTE_USER'}
StoreID: $ENV{'TALLYMAN_SID'} </b></font></a></td>
EOTEXT

  $str .="
<td valign=top width=\"70\" align=\"right\"><a href=\"index.epl\"><img height=\"50\" width=\"70\" border=\"0\" src=\""

. milton_get_image() . 

"\"></a></td>

</tr>
</table>
</td>
</tr>
</table>
</center>

</body>
</html>
";

  return $str;
}

#
# -----------------------------------------------------------------------------
#

1;
