# ORDERSTATS.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package ORDERSTATS;

use strict;

require DBLIB;

#
# 
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#  &orderstats_add_entry
#  &orderstats_delete_entry
#  &orderstats_get_stats
#  &orderstats_list_all
#
# =============================================================================
#

sub orderstats_add_entry {
  my($order_id, $affiliate_id, $logdate, $qty, $grand_total, $ship_total,
     $tax_total) = @_;

  # first, get the next sequence id

  my($next_cat_order_stat_id) = DBLIB::seq_next_get('cat_order_stat_sq');

  # and insert the stat line

  my($sqlstr) = "insert into cat_order_stat 
                (cat_order_stat_id, cat_order_id, affiliate_id, logdate,
                units, grand_total, ship_total, tax_total)
               values
               ('$next_cat_order_stat_id', '$order_id', '$affiliate_id',
                $logdate, $qty, $grand_total, $ship_total, $tax_total)";

  DBLIB::db_do($sqlstr);

  return($next_cat_order_stat_id);
}


#
# -----------------------------------------------------------------------------
# deletes an entry from the stats table.
#   takes: cat_order_id
# returns: nothing
#   notes: TAKES CAT_ORDER_ID, *NOT* CAT_ORDER_STAT_ID.
#          that means that this function is primarily useful for deleting
#          a statline associated with a particular order.  Typically used
#          for deleting bogus orders

sub orderstats_delete_entry {
  my($id) = shift;
  my($sqlstr) = "delete from cat_order_stat
                 where cat_order_id = '$id'";
  DBLIB::db_do($sqlstr);
}

#
# -----------------------------------------------------------------------------
#
#   takes: start_day, start_month, start_year, end_day, end_month, end_year
# returns: $sales,
#          $max_grand_total, $max_tax_total, $max_ship_total, $max_units,
#          $min_grand_total, $min_tax_total, $min_ship_total, $min_units,
#          $sum_grand_total, $sum_tax_total, $sum_ship_total, $sum_units,
#          $avg_grand_total, $avg_tax_total, $avg_ship_total, $avg_units
#

sub orderstats_get_stats {
  my($sday, $smon, $syear, $eday, $emon, $eyear, $affiliate_id) = @_;

  my($start_date_str) = DBLIB::date_string_make(0,0,0,$sday,$smon,$syear);
  my($end_date_str) = DBLIB::date_string_make(59,59,23,$eday,$emon,$eyear);

  my($sqlstr)="select 

               count(*), 
               max(grand_total), max(tax_total), max(ship_total), max(units),
               min(grand_total), min(tax_total), min(ship_total), min(units),
               sum(grand_total), sum(tax_total), sum(ship_total), sum(units),
               avg(grand_total), avg(tax_total), avg(ship_total), avg(units)

               from cat_order_stat
               where cat_order_stat_id <> 0 
               and logdate >= $start_date_str
               and logdate <= $end_date_str";

  if (defined($affiliate_id) && ($affiliate_id != 0)) {
    $sqlstr .= " and affiliate_id = '$affiliate_id'";
  }

  return(DBLIB::db_fetchrow_array($sqlstr));
}

#
# -----------------------------------------------------------------------------
#
#   takes: start_day, start_month, start_year, end_day, end_month, end_year
# returns: a list of all of the orders that were logged in that date range
#          cat_order_stat_id, cat_order_id, affiliate_id, logdate,
#          units, grand_total, ship_total, tax_total

sub orderstats_list_all {
  my($sday, $smon, $syear, $eday, $emon, $eyear, $affiliate_id) = @_;

  my($start_date_str) = DBLIB::date_string_make(0,0,0,$sday,$smon,$syear);
  my($end_date_str) = DBLIB::date_string_make(59,59,23,$eday,$emon,$eyear);

  my($sqlstr)="select cat_order_stat_id, cat_order_id, affiliate_id, logdate,
                      units, grand_total, ship_total, tax_total
               from cat_order_stat
               where cat_order_stat_id <> 0 
               and logdate >= $start_date_str
               and logdate <= $end_date_str";

  if (defined($affiliate_id) && ($affiliate_id != 0)) {
    $sqlstr .= " and affiliate_id = '$affiliate_id' ";
  }
  $sqlstr .= " order by logdate";
               
  return(DBLIB::db_fetchall_arrayref($sqlstr));
}

#
# -----------------------------------------------------------------------------
#

1;
