# PAGE.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package PAGE;

use strict;

require DBLIB;
require THINGTYPE;
require CONTAINER;

# 
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#  &page_list_all
#  &page_find_by_name
#  &page_create
#  &page_delete
#  &page_get_label
#  &page_get_id
#  &page_set_label
#  &page_set_attr
#  &page_verify_id
#
# =============================================================================
#

sub page_list_all {
  my($pages) = DBLIB::db_fetchall_arrayref("select page_id, name from page
                                            where page_id <> 0
                                            order by name");

  return $pages;
}

#
# -----------------------------------------------------------------------------
#
sub page_get_id {
    my($name) = @_;

    my($id) =  DBLIB::db_fetchrow_array("
        select page_id from page 
        where name=?", 0, $name, 0);

    return $id;
}

#
# -----------------------------------------------------------------------------
#

sub page_find_by_name {
  my($label, $command, @ids) = @_;
  my($column, $op, $sqlstr, $ids_str);

  $column = "name";
  if ($command =~ /i/) {
    $label =~ tr/A-Z/a-z/;
    $column = "lower(name)";
  }

  # XXX hmmm. does 'like' work for databases other than oracle???

  $op = " = '$label'";
  if ($command =~ /s/) {
    $op = " like '%$label%'";
  }

  $sqlstr = "select page_id, name
             from page
             where $column $op";

  if ($#ids > -1) {
    my $ids_str = join(",", @ids);
    $sqlstr .= " and page_id in ($ids_str)";
  }

  return(DBLIB::db_fetchall_arrayref($sqlstr));
}

#
# -----------------------------------------------------------------------------
#

sub page_create {
  my($name, $type_id) = @_;

  # get the next page id
  
  my($nextpageid) = DBLIB::seq_next_get("page_sq");

  # create the page

  DBLIB::db_do("insert into page (page_id, name)
                values
                ('$nextpageid', '$name')");

  # add to connecting table
  THINGTYPE::thingtype_add_thing($THING::page, $type_id, $nextpageid);

  return($nextpageid);  
}

#
# -----------------------------------------------------------------------------
#

sub page_delete {
  my($pageid) = @_;

  # Find and delete the page anywhere it appears in the container system
  my($rowlistref) = CONTAINER::container_find($THING::page, $pageid);

  my($row);
  foreach $row (@$rowlistref) {
    CONTAINER::container_delete($row);
  }

  # delete all of the snippets
  SNIPPET::snip_delete_all($THING::page, $pageid);

  # delete from the thing<->type table
  THINGTYPE::thingtype_delete_thing_to_type($THING::page, $pageid);

  # delete the actual page.
  DBLIB::db_do("delete from page where page_id = '$pageid'");
}


#
# -----------------------------------------------------------------------------
#

sub page_get_label {
  my($pageid)=@_;

  my($label) = DBLIB::db_fetchrow_array("select name from page 
                                         where page_id = ?",
					0, $pageid, 1);

  return($label);
}

#
# -----------------------------------------------------------------------------
#

sub page_set_label {
  my($pid,$name) = @_;

  DBLIB::db_do("update page
               set name='$name'
               where page_id='$pid'");
}

#
# -----------------------------------------------------------------------------
#

sub page_set_attr {
  my($pid, %vals) = @_;
  my($str, $key, @vkeys);

  @vkeys = keys(%vals);
  if ($#vkeys < 0) {
    return;
  }

  $str = "update page set ";
  foreach $key (@vkeys) {
    $str .= "$key='$vals{'$key'}', ";
  }
  chop $str;
  chop $str;

  $str .= " where page_id = '$pid'";

  DBLIB::db_do($str);
}

#
# -----------------------------------------------------------------------------
#

sub page_verify_id {
  return DBLIB::verify_id('page_id', 'page', @_);
}
#

# -----------------------------------------------------------------------------
#

1;







