# PAYMENT.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package PAYMENT;

use strict;
require DBLIB;

## =============================================================================
##  This file is the payment functionality.  It's all local
##
## =============================================================================


## =============================================================================
##  PAYMENT
## =============================================================================
##  These are the avaliable functions
##
##  listall            returns arrayref of all customer id's
##  create             creates a new customer
##  delete             deletes a customer
##  get_info           returns all of the info for a specific customer
##  set_attr           allows setting of various customer attributes
##  verify_id          verifies legit payment id

## =============================================================================
##  IMPLEMENTATIONS
## =============================================================================

## -----------------------------------------------------------------------------
##   func: listall
##   desc: lists all of the payments
##  param: none
##    ret: arrayref to list payment id's
##  notes: this is probably more or less useless
## -----------------------------------------------------------------------------

sub listall {
    
    my $sqlstr = "select id, type_label, field1, field2, field3, field4, field5, amnt
                  from payment";
    my $ref = DBLIB::db_fetchall_arrayref($sqlstr);


    return $ref;
}


## -----------------------------------------------------------------------------
##   func: create
##   desc: creates a new payment
##  param: type_label, f1, f2, f3, f4, f5, amnt
##    ret: payment id
##  notes: 
## -----------------------------------------------------------------------------

sub create {
    my ($type_label, $f1, $f2, $f3, $f4, $f5, $amnt) = @_;

    ## get next sequence
    my $id = DBLIB::seq_next_get("payment_sq");

    my $sqlstr = "insert into payment
                  (id, type_label, field1, field2, field3, field4, field5, amnt)
                  values
                  ($id, '$type_label', '$f1', '$f2', '$f3', $f4, '$f5', '$amnt')";
  DBLIB::db_do($sqlstr);
    
    return $id;
}


## -----------------------------------------------------------------------------
##   func: delete
##   desc: deletes a payment
##  param: payment_id
##    ret: 1/ undef
##  notes: don't do this
## -----------------------------------------------------------------------------

sub delete {
    my ($id) = @_;

    DBLIB::db_transact_begin();

    ## clean up any fk in order_payment
    
    my $sqlstr = "delete from cat_order_payment where payment_id = $id";
    DBLIB::db_do($sqlstr);

    ## clean up any fk in orderline_payment
    
    $sqlstr = "delete from orderline_payment where payment_id = $id";
    DBLIB::db_do($sqlstr);

    ## delete the actual payment
    $sqlstr = "delete from payment where id = $id";
    
    DBLIB::db_do($sqlstr);

    DBLIB::db_transact_end();

    return 1;
}

## -----------------------------------------------------------------------------
##   func: get_info
##   desc: returns info about a payment
##  param: payment id
##    ret: type_label, f1, f2, f3, f4, f5, amnt
##  notes: 
## -----------------------------------------------------------------------------

sub get_info {
    my ($id) = @_;

    my $sqlstr = "select type_label, field1, field2, field3, field4, field5, amnt
                  from payment where id = $id";

    my @info = DBLIB::db_fetchrow_array($sqlstr);

    return @info;
}


## -----------------------------------------------------------------------------
##   func: set_attr
##   desc: sets attributes of the payment
##  param: $id, %attr
##    ret: 1/ undef
##  notes: 
## -----------------------------------------------------------------------------

sub set_attr {
    my ($id, %attrs) = @_;
    
    ## create sqlstr
    my $sqlstr = "update payment set ";
    
    my ($key, $val);

    foreach $key (keys(%attrs)) {
	$sqlstr .= "$key = '$attrs{$key}', ";
    }

    chop $sqlstr;
    chop $sqlstr;

    $sqlstr .= " where id = $id";

  DBLIB::db_do($sqlstr);

    return 1;
}

## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies avalable payment id
##  param: payment_id
##    ret: 1/ 0 
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
    return DBLIB::verify_id("id", "payment", @_);
}


1;







