# PAYMENT_TYPE.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package PAYMENT_TYPE;

use strict;
require DBLIB;


## ============================================================================
##  This file is the payment_type functionality.  It's all local
##  These are left as originally implemented for the sake of time
##  they really should be generalized
## ============================================================================


## ============================================================================
##  PAYMENT
## ============================================================================
##  These are the avaliable functions
##
##  list_all           not sure how different from following
##  list_all_available returns all of the available payment types
##  get_info           returns all of the info for a specific payment_type
##  set_info           allows setting of payment_type attributes
##  get_label          returns the payment_type label
##  verify_id          verifies that the specified object actually exists


## ============================================================================
##  IMPLEMENTATIONS
## ============================================================================

## ----------------------------------------------------------------------------
##   func: list_all
##   desc: lists all payment types
##  param: none
##    ret: referend to id, label, accepted, widgettype
##  notes: 
## ----------------------------------------------------------------------------

sub list_all {
  my($sqlstr) = "select paymenttype_id, label, accepted, widgettype
                 from paymenttype 
                 where paymenttype_id <> 0";

  my $ref = DBLIB::db_fetchall_arrayref($sqlstr);

  return $ref;
}


## ----------------------------------------------------------------------------
##   func: list_all_available
##   desc: lists all accepted payment types
##  param: none
##    ret: arrayref to id, label, accepted, widgettype
##  notes: 
## ----------------------------------------------------------------------------

sub list_all_available {
  my($sqlstr) = "select paymenttype_id, label, accepted, widgettype
                 from paymenttype 
                 where paymenttype_id <> 0
                 and accepted = 'yes'";

  my $ref = DBLIB::db_fetchall_arrayref($sqlstr);

  return $ref;
}


## ----------------------------------------------------------------------------
##   func: get_info
##   desc: returns info on a particular payment type
##  param: id
##    ret: (label, accepted, widgettype)
##  notes: 
## ----------------------------------------------------------------------------


sub get_info {
  my($id) = shift;
  my($sqlstr) = "select label, accepted, widgettype
                 from paymenttype
                 where paymenttype_id = '$id'";
  return DBLIB::db_fetchrow_array($sqlstr);
}

## ----------------------------------------------------------------------------
##   func: set_info
##   desc: sets the info on a payment type
##  param: id, label, accepted
##    ret: none
##  notes: accepted is forced to be either 'yes' or 'no'
## ----------------------------------------------------------------------------


sub set_info {
  my($id, $label, $accepted, $widgettype) = @_;

  if (!($accepted eq 'yes' || $accepted eq 'no')) {
    $accepted='no';  # off by default
  }

  my($sqlstr) = "update paymenttype set
                 label='$label',
                 accepted='$accepted',
                 widgettype='$widgettype'
                 where paymenttype_id = '$id'";

  DBLIB::db_do($sqlstr);
}

## -----------------------------------------------------------------------------
##   func: get_label
##   desc: returns info on a particular payment type
##  param: id
##    ret: (label, accepted)
##  notes: 
## -----------------------------------------------------------------------------


sub get_label {
  my($id) = shift;
  my($sqlstr) = "select label from paymenttype
                 where paymenttype_id='$id'";
  my ($str) = DBLIB::db_fetchrow_array($sqlstr);

  return $str;
}

## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies that the specified object actually exists
##  param: id
##    ret: 1, 0 or not at all, depending on options
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
  return DBLIB::verify_id('paymenttype_id', 'paymenttype', @_);
}

1;






