# SENDMAIL.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package SENDMAIL;

use strict;
require "MILTON.pm";
require "KNAR.pm";

#
# 
# AVAILABLE FUNCTIONS AND VARIABLES DEFINED IN THIS PACKAGE:
#
#  &sendmail
#
# =============================================================================
#

my $SENDMAIL_PATH = '/usr/sbin/sendmail';

#
# -----------------------------------------------------------------------------
#
# sends an email message to a person
#
#   takes: destination email address, from address, subject, text
# returns: nothing
#

sub sendmail {
  my($isParent);

  my($to) = shift;
  my($from) = shift;
  my($subject) = shift;
  my($msgtext) = shift;

  # this is where the message will go if it bounces
  # XXX should be a config option!

  my($sender) = KNAR::knar_entry_get('SENDMAIL_BOUNCEBACK');
  my($mail_cmd) = $SENDMAIL_PATH . " -f$sender -t";

  # clean up the addresses, for use on the mailer command line

  $to = SENDMAIL::parse_address($to);

  # open the process

  if (defined($isParent = open(MAIL, "|-"))) {
    SENDMAIL::do_exec_sendmail(split(' ', $mail_cmd))
      unless ($isParent);
  } else {
    MILTON::fatal_error("Failed to fork prior to mailer exec!");
  }

  print MAIL 
"To: $to
From: $from
Subject: $subject
Reply-To: $from

$msgtext

";

  close(MAIL);
  return;
}

#
# -----------------------------------------------------------------------------
#
# Exec a mailer process
#

sub do_exec_sendmail {

  MILTON::fatal_error("do_exec_sendmail, number of args <= 1 unsafe to exec")
    if scalar(@_) <= 1;

  MILTON::fatal_error("do_exec_sendmail, mailer $_[0] not executable")
    unless (-x $_[0]);

  open(STDOUT,">/dev/null");

  exec(@_);

  MILTON::fatal_error("Failed to exec mailer \"@_\": $!");
}

#
# -----------------------------------------------------------------------------
#

sub parse_address {
  my($string) = shift;
  my(@strings);
  my($i);

  1 while $string=~s/\([^\(\)]*\)//g; 		# strip comments
  1 while $string=~s/"[^"]*"\s//g;		# strip comments"
  @strings=split(/,/,$string);			# split into parts

  foreach $i (@strings) {
    1 while $i=~s/.*<(.*)>.*/$1/;
    $i=~s/^\s+//;
    $i=~s/\s+$//;
  }

  return(join(", ",@strings));
}

#
# -----------------------------------------------------------------------------
#


1;







