# SHIPMENT.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package SHIPMENT;

use strict;
require DBLIB;
require ADDRESS;

## =============================================================================
##  This file is the shipment functionality.  It's all local
##
## =============================================================================


## =============================================================================
##  shipment
## =============================================================================
##  These are the avaliable functions
##
##  listall            returns arrayref of all customer id's
##  create             creates a new customer
##  delete             deletes a customer
##  get_info           returns all of the info for a specific customer
##  set_attr           allows setting of various customer attributes
##  verify_id          verifies legit shipment id

## =============================================================================
##  IMPLEMENTATIONS
## =============================================================================

## -----------------------------------------------------------------------------
##   func: listall
##   desc: lists all of the shipments
##  param: none
##    ret: arrayref to shipment id's
##  notes: 
## -----------------------------------------------------------------------------

sub listall {
    
    my $sqlstr = "select id, type_label, cost, address_id from shipment";
    my $ref = DBLIB::db_fetchall_arrayref($sqlstr);

    return $ref;
}


## -----------------------------------------------------------------------------
##   func: create
##   desc: creates a new shipment
##  param: type_label, cost, address_id
##    ret: shipment_id
##  notes: 
## -----------------------------------------------------------------------------

sub create {
    my ($type_label, $cost, $address_id) = @_;

    ## get next sequence
    my $id = DBLIB::seq_next_get("shipment_sq");

    my $sqlstr = "insert into shipment
                  (id, type_label, cost, address_id)
                  values
                  ($id, '$type_label', $cost, $address_id)";

  DBLIB::db_do($sqlstr);
    
    return $id;
}


## -----------------------------------------------------------------------------
##   func: delete
##   desc: deletes a shipment
##  param: shipment_id
##    ret: 1/ undef
##  notes: don't do this
## -----------------------------------------------------------------------------

sub delete {
    my ($id) = @_;

    DBLIB::db_transact_begin();

    ## clean up any fk in shipment
    my $sqlstr = "delete from orderline_shipment where shipment_id = $id";

    DBLIB::db_do($sqlstr);
    
    ## get address id from the shipment
    $sqlstr = "select address_id from shipment where id = $id";
    my ($addr_id) = DBLIB::db_fetchrow_array($sqlstr);

    ## delete the actual address
    $sqlstr = "delete from shipment where id = $id";
    
    DBLIB::db_do($sqlstr);

    ## delete the address
    ADDRESS::delete($addr_id);

    DBLIB::db_transact_end();

    return 1;
}

## -----------------------------------------------------------------------------
##   func: get_info
##   desc: returns info about shipment
##  param: shipment_id
##    ret: type_label, cost, address_id
##  notes: 
## -----------------------------------------------------------------------------

sub get_info {
    my ($id) = @_;

    my $sqlstr = "select type_label, cost, address_id
                  from shipment where id = $id";

    my @info = DBLIB::db_fetchrow_array($sqlstr);

    return @info;
}


## -----------------------------------------------------------------------------
##   func: set_attr
##   desc: sets attributes of the shipment
##  param: $id, %attr
##    ret: 1/ undef
##  notes: 
## -----------------------------------------------------------------------------

sub set_attr {
    my ($id, %attrs) = @_;
    
    ## create sqlstr
    my $sqlstr = "update shipment set ";
    
    my ($key, $val);

    foreach $key (keys(%attrs)) {
	$sqlstr .= "$key = '$attrs{$key}', ";
    }

    chop $sqlstr;
    chop $sqlstr;

    $sqlstr .= " where id = $id";

  DBLIB::db_do($sqlstr);

    return 1;
}

## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies avalable shipment id
##  param: shipment_id
##    ret: 1/ 0 
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
    return DBLIB::verify_id("id", "shipment", @_);
}



1;



