# STOCK.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package STOCK;
use strict;

require DBLIB;
require ITEM;
#require CUMULUS;

use vars qw (%get_info %set_attr %allocate %deallocate %inv_find_low);

##
## ============================================================================
## STOCK STUFF -- including remote DB stuff
## ============================================================================
##

## ----------------------------------------------------------------------------
##  STOCK API 
##
##  get_info 
##  set_attr 
##  asssoc
##  deassoc
##  inv_get_info
##  inv_set_attr
##  inv_alloc
##  inv_dealloc
##
## ----------------------------------------------------------------------------

## ----------------------------------------------------------------------------
##   func:  inv_get_info
##   desc:  gets inventory information
##  param:  $inventory_id
##    ret:  ($sku, $price, $weight, $volume, $atp, $rt, $drq)
##  notes:
## ----------------------------------------------------------------------------

sub inv_get_info_local {
    my ($inventory_id) = @_;

    my $sqlstr = "select sku, price, weight, volume, atp_qty, reserve_threshold,
                  def_reserve_qty 
                  from inventory_local 
                  where inventory_id='$inventory_id'"; 
 
    my @result = DBLIB::db_fetchrow_array($sqlstr);
       
    return @result;
}

## ----------------------------------------------------------------------------
##   func:  inv_set_attr
##   desc:  sets inventory attrs
##  param:  $inv_id, hash of attr_names and values
##    ret:  1
##  notes:
## ----------------------------------------------------------------------------

sub inv_set_attr_local {
    
    my ($inventory_id, %attrs) = @_;

    ## create sqlstr
    my $sqlstr = "update inventory_local set ";
    
    my ($key, $val);

    foreach $key (keys(%attrs)) {
	$sqlstr .= "$key = '$attrs{$key}', ";
    }

    chop $sqlstr;
    chop $sqlstr;
    
    $sqlstr .= " where inventory_id = '$inventory_id'";

    DBLIB::db_do($sqlstr);

}

## ----------------------------------------------------------------------------
##   func:  inv_allocate
##   desc:  attempts to allocate from the inventory, returns undef if unable
##          to do so
##  param:  $inventory_id, $num_alloc
##    ret:  1/ undef
##  notes:
## ----------------------------------------------------------------------------

sub inv_allocate_local {
    my ($inv_id, $num_alloc) = @_;
    
    ## make sure atp_qty >= $num_alloc
    my $sqlstr = "select atp_qty from inventory_local where inventory_id = '$inv_id'";
    my ($atp) = DBLIB::db_fetchrow_array($sqlstr);
    
    return DBLIB::non_fatal_error("Cannot allocate $num_alloc items from $atp avaliable of $inv_id.") if ($atp < $num_alloc);

    ##allocate local inventory
    $sqlstr = "update inventory_local set atp_qty = atp_qty - $num_alloc where inventory_id = '$inv_id'";
    DBLIB::db_do($sqlstr);

    return 1;
}

## ----------------------------------------------------------------------------
##   func:  inv_deallocate
##   desc:  deallocates inventory item
##  param:  $inventory_id, $num_dealloc
##    ret:  1/ undef
##  notes:  
## ----------------------------------------------------------------------------

sub inv_deallocate_local {
    my ($inv_id, $num_dealloc) = @_;
    
    ##deallocate local inventory

    my $sqlstr = "update inventory_local set atp_qty = atp_qty + $num_dealloc 
                  where inventory_id = '$inv_id'";

    DBLIB::db_do($sqlstr);

    return 1;
}


## ----------------------------------------------------------------------------
##   func:  inv_create_local
##   desc:  create new local inventory item
##  param:  sku,price,weight,volume,atp_qty,reserve_threshold,def_reserve_qty
##    ret:  inventory id
##  notes:  
## ----------------------------------------------------------------------------

sub inv_create_local {
    my ($sku, $price, $weight, $volume, $atp, $rt, $drq) = @_;

    # get the next inventory id

    my $inventory_id = DBLIB::seq_next_get("inventory_sq");

    # insert the stock item

    my $sqlstr = "insert into inventory_local
                  (inventory_id, sku, price, weight, volume, 
                   atp_qty,reserve_threshold,def_reserve_qty) 
                  values
                  ('$inventory_id','$sku','$price','$weight',
                   '$volume','$atp','$rt','$drq')";

    DBLIB::db_do($sqlstr);

    return($inventory_id);
}

## ----------------------------------------------------------------------------
##   func:  inv_delete_local
##   desc:  deletes local inventory item
##  param:  inventory id
##    ret:  1/undef
##  notes:  
## ----------------------------------------------------------------------------


sub inv_delete_local {
  my ($inventory_id) = @_;

  DBLIB::db_do("delete from inventory_local
                where inventory_local.inventory_id = '$inventory_id'");

  return 1;
}


## ----------------------------------------------------------------------------
##   func:  assoc
##   desc:  associtates an inventory Id with a stock Id and a stock_impl_type
##  param:  $inv_id, $stock_impl_type
##    ret:  $stock_id
##  notes:  
## ----------------------------------------------------------------------------

sub assoc {
    my ($inventory_id, $stock_impl_type) = @_;
    
    ##now we need to get a new stock_id
    my $stock_id = DBLIB::seq_next_get("stock_sq");

    ##then we create the entry in the stock_access table
    my $sqlstr = "insert into stock_access
                  (stock_id, inventory_id, stock_impl_type) values
                  ($stock_id, '$inventory_id', '$stock_impl_type')";

    DBLIB::db_do($sqlstr);

    return $stock_id;
}

## ----------------------------------------------------------------------------
##   func:  deassoc
##   desc:  deassocitates an inventory Id with a stock Id 
##          will delete a local inventory item
##  param:  $stock_id
##    ret:  1/ undef
##  notes:  
## ----------------------------------------------------------------------------

sub deassoc {
    my ($stock_id) = @_;
    
    ##  delete entry from stock_access table
    my $sqlstr = "select inventory_id, stock_impl_type from stock_access 
                  where stock_id = $stock_id";
    
    my ($inv_id, $impl_type) = DBLIB::db_fetchrow_array($sqlstr);

    inv_delete_local($inv_id) if ($impl_type eq "LOCAL");

    $sqlstr = "delete from stock_access where
               stock_id = $stock_id";

    DBLIB::db_do($sqlstr);

    return 1;
}

## ----------------------------------------------------------------------------
##   func:  get_id
##   desc:  finds a stock id associtated with an inventory item
##  param:  $inventory_id
##    ret:  $stock_id, $stock_impl_type/ undef
##  notes:  
## ----------------------------------------------------------------------------

sub get_id {
    my ($inv_id) = @_;

    my $sqlstr = "select stock_id, stock_impl_type from stock_access
                  where inventory_id = ?";

#    my @row = DBLIB::db_fetchrow_array($sqlstr, 0, $inv_id, 1);
    my @row = DBLIB::db_fetchrow_array($sqlstr, 0, $inv_id, 0);
    return @row;
}


## ----------------------------------------------------------------------------
##   func:  inv_find_low
##   desc:  finds low inventory
##  param:  none
##    ret:  reference to low inventory id's
##  notes:  
## ----------------------------------------------------------------------------

sub inv_find_low_local {
    my $sqlstr = "select inventory_id from inventory_local, 
                  where inventory_id <> '0'
                  and atp_qty <= reserve_theshold";

    my($ref) = DBLIB::db_fetchall_arrayref($sqlstr);

    return $ref;
}

## ----------------------------------------------------------------------------
##   func: inv_translate
##   desc: changes a stock id to a inventory_id and impl_type
##  param: stock_id
##    ret: inventory_id, impl_type
##  notes:
## ----------------------------------------------------------------------------

sub inv_translate {
    my ($stock_id) = @_;
    my $sqlstr = "select inventory_id, stock_impl_type
                  from stock_access where stock_id = $stock_id";

    my @result = DBLIB::db_fetchrow_array($sqlstr);
    return @result;
}

## =============================================================================
##  IMPLEMENTATION HASHES
## =============================================================================

$get_info     {"LOCAL"} = \&inv_get_info_local;
$set_attr     {"LOCAL"} = \&inv_set_attr_local;
$allocate     {"LOCAL"} = \&inv_alloc_local;
$deallocate   {"LOCAL"} = \&inv_dealloc_local;
$inv_find_low {"LOCAL"} = \&inv_find_low_local;


## =============================================================================
##  API CALLS
## =============================================================================

sub get_info {
    my ($inv_id, $impl_type) = inv_translate(shift);
    return &{$get_info{$impl_type}}($inv_id, @_);
}

sub set_attr {
    my ($inv_id, $impl_type) = inv_translate(shift);
    return &{$set_attr{$impl_type}}($inv_id, @_);
}

sub allocate {
    my ($inv_id, $impl_type) = inv_translate(shift);
    return &{$allocate{$impl_type}}($inv_id, @_);
}

sub deallocate {
    my ($inv_id, $impl_type) = inv_translate(shift);
    return &{$deallocate{$impl_type}}($inv_id, @_);
}

sub inv_find_low {
}



