# TABLE.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

#  This library is a centralized place to put table information needed
#  by other libraries.  This makes it easier to keep in sync with the
#  make/generic/*in files.

package TABLE;

use strict;

# These numbers will be subtracted from in width()
my(%width) = (
	      "address:name"      => 80,
	      "address:street1"   => 100,
	      "address:street2"   => 100,
	      "address:city"      => 80,
	      "address:state"     => 20,
	      "address:zip"       => 20,
	      "address:country"   => 80,

	      "customer:name"       => 80,
	      "customer:company"    => 100,
	      "customer:email"      => 100,
	      "customer:home_phone" => 80,
	      "customer:work_phone" => 80,

	      "cat_order:general_ins" => 4000,

	      "payment:field1"  => 100,
	      "payment:field2"  => 100,
	      "payment:field3"  => 100,
	      "payment:field4"  => 100,
	      "payment:field5"  => 100,

	      );

#
# -----------------------------------------------------------------------------
#
sub width {
    my($table,$field) = @_;

    # Return the result (with a little padding)
    return $width{"$table:$field"} if exists($width{"$table:$field"});
    MILTON::fatal_error("Unknown table/column: $table/$field");
}

#
# -----------------------------------------------------------------------------
#



1;
