# TAX.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package TAX;

use strict;
require DBLIB;


## ==========================================================================
##  This file is the tax functionality.  It's all local
##
## =============================================================================


## =============================================================================
##  TAX
## =============================================================================
##  These are the avaliable functions
##
##  listall            returns arrayref of all tax id's
##  create             creates a new tax
##  delete             deletes a tax
##  get_info           returns all of the info for a specific tax
##  set_attr           allows setting of various tax attributes
##  verify_id          verify legit tax id

## =============================================================================
##  IMPLEMENTATIONS
## =============================================================================

## -----------------------------------------------------------------------------
##   func: listall
##   desc: lists all of the tax
##  param: none
##    ret: arrayref of tax id's
##  notes: more or less useless
## -----------------------------------------------------------------------------

sub listall {
    
    my $sqlstr = "select id, type_label, amnt from tax";
    my $ref = DBLIB::db_fetchall_arrayref($sqlstr);

    return $ref;
}


## -----------------------------------------------------------------------------
##   func: create
##   desc: creates a new tax
##  param: type_label, cost, address_id
##    ret: tax_id
##  notes: 
## -----------------------------------------------------------------------------

sub create {
    my ($type_label, $amnt) = @_;

    ## get next sequence
    my $id = DBLIB::seq_next_get("tax_sq");

    my $sqlstr = "insert into tax
                  (id, type_label, amnt)
                  values
                  ($id, '$type_label', $amnt)";

  DBLIB::db_do($sqlstr);
    
    return $id;
}


## -----------------------------------------------------------------------------
##   func: delete
##   desc: deletes a tax
##  param: tax_id
##    ret: 1/ undef
##  notes: don't do this
## -----------------------------------------------------------------------------

sub delete {
    my ($id) = @_;

    DBLIB::db_transact_begin();

    ## clean up any fk in tax
    my $sqlstr = "delete from orderline_tax where tax_id = $id";

    DBLIB::db_do($sqlstr);
    
    ## delete the actual tax
    $sqlstr = "delete from tax where id = $id";

    DBLIB::db_do($sqlstr);

    DBLIB::db_transact_end();

    return 1;
}

## -----------------------------------------------------------------------------
##   func: get_info
##   desc: returns info about tax
##  param: tax
##    ret: type_label, amnt
##  notes: 
## -----------------------------------------------------------------------------

sub get_info {
    my ($id) = @_;

    my $sqlstr = "select type_label, amnt 
                  from tax where id = $id";

    my @info = DBLIB::db_fetchrow_array($sqlstr);

    return @info;
}


## -----------------------------------------------------------------------------
##   func: set_attr
##   desc: sets attributes of the tax
##  param: $id, %attr
##    ret: 1/ undef
##  notes: 
## -----------------------------------------------------------------------------

sub set_attr {
    my ($id, %attrs) = @_;
    
    ## create sqlstr
    my $sqlstr = "update tax set ";
    
    my ($key, $val);

    foreach $key (keys(%attrs)) {
	$sqlstr .= "$key = '$attrs{$key}', ";
    }

    chop $sqlstr;
    chop $sqlstr;

    $sqlstr .= " where id = $id";

  DBLIB::db_do($sqlstr);

    return 1;
}

## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies avalable tax id
##  param: tax_id
##    ret: 1/ 0 
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
    return DBLIB::verify_id("id", "tax", @_);
}

1;
