# TAX_TYPE.pm
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package TAX_TYPE;

use strict;
require DBLIB;


## ============================================================================
##  This file is the tax_type functionality.  It's all local
##  These are left as originally implemented for the sake of time
##  they really should be generalized
## ============================================================================


## ============================================================================
##  TAX
## ============================================================================
##  These are the avaliable functions
##
##  list_all           returns arrayref of all tax_type id's
##  create             creates a new tax_type
##  delete             deletes a tax_type
##  get_info           returns all of the info for a specific tax_type
##  set_info           allows setting of tax_type attributes
##  get_label          returns the tax_type label
##  verify_id          verifies that the specified object actually exists

## ============================================================================
##  IMPLEMENTATIONS
## ============================================================================

## ----------------------------------------------------------------------------
##   func: list_all 
##   desc: returns all info for tax types 
##  param: none
##    ret: ref to array of taxtype_id, lab, percentage
##  notes: 
## ----------------------------------------------------------------------------

sub list_all {
  my($sqlstr) = "select taxtype_id, label, percentage
                 from taxtype 
                 where taxtype_id <> 0";

  my $ref = DBLIB::db_fetchall_arrayref($sqlstr);
  return $ref;
}


## ----------------------------------------------------------------------------
##   func: create
##   desc: creates a new tax type
##  param: label, percentage
##    ret: 1 /undef
##  notes: 
## ----------------------------------------------------------------------------

sub create {
  my($label, $percentage) = @_;

  my($id) = DBLIB::seq_next_get('taxtype_sq');

  my($sqlstr) = "insert into taxtype (taxtype_id,label,percentage) values
                 ($id,'$label','$percentage')";

  DBLIB::db_do($sqlstr);

  return 1;
}

## ----------------------------------------------------------------------------
##   func: delete
##   desc: deletes a tax type 
##  param: tax_type_id
##    ret: 1/ undef
##  notes: 
## ----------------------------------------------------------------------------

sub delete {
  my($id) = @_;

  my($sqlstr) = "delete from taxtype where taxtype_id = '$id'";

  DBLIB::db_do($sqlstr);

  return 1;
}

## ----------------------------------------------------------------------------
##   func: set_info
##   desc: changes the info for a tax_type
##  param: id, label, percentage
##    ret: 1/ undef
##  notes: 
## ----------------------------------------------------------------------------

sub set_info {
  my($id, $label, $percentage) = @_;

  my($sqlstr) = "update taxtype
                 set label='$label', percentage='$percentage'
                 where taxtype_id = '$id'";
  DBLIB::db_do($sqlstr);

  return 1;
}

## ----------------------------------------------------------------------------
##   func: get_info
##   desc: returns the info for a tax_type
##  param: id
##    ret: (label, percentage)
##  notes: 
## ----------------------------------------------------------------------------

sub get_info {
  my($id) = @_;

  my($sqlstr) = "select label,percentage from taxtype 
                 where taxtype_id = '$id'";

  my @row = DBLIB::db_fetchrow_array($sqlstr);
  return @row;
}


## ----------------------------------------------------------------------------
##   func: get_label
##   desc: returns the label for a tax_type
##  param: id
##    ret: label
##  notes: 
## ----------------------------------------------------------------------------

sub get_label {
    my($id) = @_;

    my($sqlstr) = "select label from taxtype where taxtype_id = '$id'";
   
    my ($label) = DBLIB::db_fetchrow_array($sqlstr);
    return $label;
}

## ----------------------------------------------------------------------------
##   func: verify_id
##   desc: verifies that the specified object actually exists
##  param: id
##    ret: 1, 0 or not at all, depending on options
##  notes: 
## ----------------------------------------------------------------------------

sub verify_id {
  return DBLIB::verify_id('taxtype_id', 'taxtype', @_);
}

1;
