#
# USER_MILTON.PM
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

package USER_MILTON;

use strict;

#
# This module is for end-user defined additions to Milton.
#

use vars qw($ok $notok);
$ok = 1;
$notok = 0;

use vars qw(%snippet_method %snippet_desc);
use vars qw($local_method);

%snippet_desc   = (
    "local" => "local snippet table entry"
		   );

%snippet_method = (
    "local" => \&local_snippet    
		   );

#
# =============================================================================
#
# USER API
#
# =============================================================================
#

#
# -----------------------------------------------------------------------------
# A vacuous snippet handler, for locally stored snippets.
#
sub local_snippet {
    my($cmd) = shift;
    
    if($cmd eq "c") {
        my($id) = SNIPPET::snip_do_create(@_);
	return ($ok, $id);
    } elsif($cmd eq "d") {
	SNIPPET::snip_do_delete(@_);
  	return ($ok, "");
    } elsif($cmd eq "r") {
	my($text) = SNIPPET::snip_do_get(@_);
	return ($ok, $text);
    } elsif($cmd eq "u") {
	SNIPPET::snip_do_update(@_);
	return ($ok, "");
    } else {
	MILTON::fatal_error("Unknown snippet command $cmd.");
    }
}



#
# -----------------------------------------------------------------------------
#



#
# -----------------------------------------------------------------------------
#



1;
