#!/usr/bin/perl

# macro.pl
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

# Cheap, dirty (and did I mention slow?) macro preprocessor
# Jason E. Holt 24 June 1999
# For akopia, inc.

# The "include" file is in macros.pl, which should contain a reference to 
# a hash of words (macros) and their translations.  Any words in the hash 
# that show up on the stdin are translated and written to the stdout.

# BUGS: no macro functions()

unless($ARGV[0] eq "oracle" or $ARGV[0] eq "postgresql") {
print <<EOF;

usage:

$0 [oracle|postgresql]

Takes a generic sql-ish file on stdin, and outputs oracle- or postgresql-
specific SQL on stdout.

EOF
exit 1;
}

require "macros.pl";

%words = ($ARGV[0] eq "oracle" ? %oracle : %postgres);

while(<STDIN>){
#	s/\b([a-zA-Z0-9_]+)\b/exists($words{$1}) ? $words{$1} : $1/eg;
	s/\{(\w+)\}/exists($words{$1}) ? $words{$1} : $1/eg;
	print $_;
}
