# macros.pl
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

# To be included by macro.pl


#
# DISPTEXT_PRE and DISPTEXT_POST are used to echo a value to STDOUT when
# the make_all.sql script is running.  Each script echoes it's own name 
# when executed; that way, if something goes wrong in a large batch operation,
# you'll at least know what file it happened in.
#
# RUN is used by the make_all.sql script to execute other scripts.
#

%oracle = (
   INTEGER => "NUMBER(10)",
   VARCHAR => "VARCHAR2",
   PRICE => "NUMBER(20,4)",
   FLOAT => "NUMBER(20,4)",
   DEFDATE => "TO_DATE('01-01-1969','DD-MM-YYYY')",
   NEXTVAL_PRE => "",  # A kludge, so postgres can put nextval('') around 
   NEXTVAL_POST => ".nextval",  # the name, while oracle can put .nextval
   DATETIME => "DATE", # for dates which include time
   DISPTEXT_PRE => "select '",
   DISPTEXT_POST => "' from dual;",
   LONG => "LONG",
   RUN => "start",
   FK_IGNORE => " "
); 

%postgres = (
   INTEGER => "int4",   
   WITH => "",  # As in "CREATE SEQUENCE START WITH..." in Oracle
   PRICE => "float8",
   FLOAT => "float8",
   DEFDATE => "'January 1, 1969'",
   NEXTVAL_PRE => "nextval('",
   NEXTVAL_POST => "')",
   DATETIME => "datetime",
   DISPTEXT_PRE => "--",
   DISPTEXT_POST => "",
   LONG => "TEXT",
   RUN => "\\i",
   FK_IGNORE => "--"
);
