#!/usr/bin/perl

# make_sql.pl
# copyright (c) 1999 akopia, inc.
#
########################################################################
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of version 2 of the GNU General Public
#    License as published by the Free Software Foundation.
#    
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
########################################################################

# This program runs macro.pl for each of the .in files to create the 
# appropriate .sql files.

$cmd = "./macro.pl";

unless($ARGV[0] eq "postgresql" or $ARGV[0] eq "oracle") {
print <<EOF;

usage:

$0 [oracle | postgresql]

Runs $cmd on *.in in the current directory, producing .sql 
files appropriate for the specified database.

EOF
exit 1;
}

$input_dir = "generic";
die("Input directory \"$input_dir\" does not exist") unless(-d $input_dir);

$output_dir = ($ARGV[0] eq "oracle" ? "oracle" : "postgresql");
die("Output directory \"$output_dir\" does not exist") unless(-d $output_dir);

for(<$input_dir/*\.in>){
	$in = $_;
	s/^$input_dir\///;
	s/\.in$/\.sql/;
	print("$cmd $ARGV[0] <$in >$output_dir/$_\n");
	system("$cmd $ARGV[0] <$in >$output_dir/$_");
}

exit 0;
