# helptext.pm
#   copyright (c) 1999 akopia, inc.
#
######################################################################
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of version 2 of the GNU General Public
#   License as published by the Free Software Foundation.
#    
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
######################################################################

# -----------------------------------------------------------------------------
# HELP TEXTS FOR THE INSTALLER
# -----------------------------------------------------------------------------
#

package H;

#
# ----- main screens -----
#

$usage_screen = 
"TallyMan Installer Release 0.9 - Developer

(c) Copyright 1999, Akopia, Inc.  All Rights Reserved.
    See the LICENSE file for licensing details.

Usage: install.pl [-h] [-v]

-h -H --help    : show this screen
-v -V --verbose : enable verbose mode

";


$welcome_screen = 
"In order to install TallyMan, you must first configure the software.
  You must then configure one (or many) stores.  Each store corresponds
  to a separate set of item, pages, and products, and will generate a 
  separate set of HTML pages.

  Step 1, therefore, is to configure the software.  After you configure
  the software, you need to create a store, and go to each sub-menu to 
  complete the store configuration.  Once all store configuration is done,
  you must select 'install store,' and the store will be installed.  You will
  then be mostly ready to use the software.

  On menus such as these, a * will appear next to currently selected options,
  or steps which have already been completed.


  Press the [return] key to continue...";

$create_screen = 
"In order to create a store, we need a lot of information.  You must
  proceed through each of the install screens listed here (database,
  directories, URLs, and misc).  Once you have entered all required
  parameters, you must actually install the store by selecting 'i.'

  A star will appear by the option once it has been completed.


  Press the [return] key to continue...";

#
# ----- software config -----
#

$global_basedir = 
"This is the base directory of the TallyMan install.  All per-store sub
  directories will be installed from this point.";

$global_mode = 
"TallyMan is designed to run in one of two 'modes.'  You can run it under
  Apache and mod_perl, or in offline mode.  The apache/mod_perl combination
  is generally recommended, due to vastly superior performance.  Offline
  mode is recommended when you are running a webserver that is not apache,
  or when you cannot use mod_perl.

  When configured to use offline mode, all scripts are executed as 
  standard CGI scripts.";

#
# ----- database -----
#

$db_type =
"TallyMan runs on top of an SQL-compliant database, such as Oracle and  
  PostgreSQL.  We hope that you will be able to use your existing 
  database, but not all databases are supported.  If your database is not
  listed above, you either need to wait for a port to be finished, or try
  one of the above.  We tried very hard to make the TallyMan SQL statements
  database-independent, so there is a good chance that one of the above will
  work with your database.  It is not guaranteed, however.

  If you choose to run on an unsupported database, you will need to create
  all of the necessary tables by hand.  See the make/make_sql.pl and
  make/generic/* directories for the data; you will also need to generate
  a store configuration file by hand.";

$db_username = 
"In order to access the database tables that TallyMan needs to function
  properly, it must connect as a specific user, with a specific password.
  TallyMan will use this username whenever it attempts to connect to the 
  database.  During the install phase, TallyMan will also need to create
  tables and sequences using this account.  You cannot invent usernames
  here and hope they work; if you don't know what to put, you either need
  to create a new account, or see your database administrator.";

$db_password = 
"The password for the previously specified user.  Again, you cannot invent
  a value.  Passwords are typically case-sensitive.";

$dbi_connect_str = 
"TallyMan uses a database access library called 'DBI' to connect to the
  database.  This string is passed to DBI, informing it how the database
  connection ought to be made.

  The default value is highly recommended.";

$oracle_homedir = 
"The base directory of your Oracle installation.  A typical value might
  be /home/oracle/base/products/8.0.5.0 .";

$oracle_sid = 
"The ID of the Oracle instance to which you wish to connect.  Typically a four
  letter string, like 'ALFR' or 'EGEN'.";

$oracle_try_to_create_user = 
"TallyMan can try to automatically create the user that you have specified
  above.  In order to do so, you will need to provide the username and
  password of _another_ user (called a Database Administrator, or DBA) who is
  privileged to create other user accounts.";

$oracle_try_to_drop_user = 
"Just in case the user you specified already exists, TallyMan can try to drop
  the user for you first.  This is useful if you're re-installing, or you're
  just practicing.

  If you don't know what it means to drop a user, you should answer 'no.'";

$oracle_dba_username = 
"This is the username of the user who is privileged to create other users.";

$oracle_dba_password = 
"This is the password of the user who is privileged to create other users.";

$oracle_default_tablespace = 
"This is the tablespace you want to use when we create the TallyMan user.
  The default is 'users'.";

$oracle_temp_tablespace = 
"This is the temporary tablespace you want to use when we create the TallyMan
  user.  The default is 'temp.'";

$oracle_try_to_create_tables = 
"TallyMan runs on top of an SQL database, and needs certain tables to exist
  in order to function properly. We can create those tables automatically
  for you, if you would like.

  If you decide that you do not want this install script to try and create
  the tables for you, you will have to do it by hand.  They _must_ be
  created and accessible in order for TallyMan to function properly.";



$postgres_try_to_create_user = 
"TallyMan can try to automatically create the user that you have specified
  above.  In order to do so, you will need to provide the username and
  password of _another_ user (called a Database Administrator, or DBA) who is
  privileged to create other user accounts.";

$postgres_try_to_drop_user = 
"Just in case the user you specified already exists, TallyMan can try to drop
  the user for you first.  This is useful if you're re-installing, or you're
  just practicing.

  If you don't know what it means to drop a user, you should answer 'no.'";

$postgres_dba_username = 
"This is the username of the user who is privileged to create other users.";

$postgres_dba_password = 
"This is the password of the user who is privileged to create other users.";

$postgres_try_to_create_tables = 
"TallyMan runs on top of an SQL database, and needs certain tables to exist
  in order to function properly. We can create those tables automatically
  for you, if you would like.

  If you decide that you do not want this install script to try and create
  the tables for you, you will have to do it by hand.  They _must_ be
  created and accessible in order for TallyMan to function properly.";

#
# ----- urls -----
#

$admin_url = 
"The URL by which TallyMan's admin directory can be accessed.  The admin
  directoy is where the back office scripts are kept (like item.epl, or 
  order.epl). This value will depend on where the software has been installed,
  and on how your web server is configured.  Each URL on a web server
  corresponds to a physical directory on your server; although TallyMan knows
  in which directory it was installed, it cannot tell what URL corresponds to
  that directory.

  A typical value for this might be 'http://www.foo.com/admin', which may
  map to the physical directory '/usr/local/tallyman/admin'.

  Note that there is no trailing '/'.

  Please enter a full URL.";

$admin_secure_url = 
"The same as above, except that this URL needs to be a secure URL.  That 
  probably means SSL.  TallyMan needs to switch into secure mode whenever a
  store administrator is viewing captured orders, to maintain the security
  of the payment information.";

$tallyman_url = 
"This is the unsecure URL of the tallyman directory.  The tallyman directory
  is where scripts that should not be access-protected are kept (such as 
  cart.epl [the shopping basket] -- you want anyone to be able to use
  it without entering a password).

  A typical value for this might be 'http://www.foo.com/tallyman'.";

$tallyman_secure_url = 
"Same as the admin secure URL.  TallyMan needs to switch into secure mode
  any time it requests payment information from a customer.";

#
# ----- directories -----
#

$regen_output_dir =
"TallyMan comes with a powerful site-creation system.  It will create your
  web site for you, using a set of templates and data that you supply.
  The HTML files it generates need to be placed somewhere.  Enter the
  directory you wish to use here.";

$regen_output_url = 
"The URL by which TallyMan can access the directory specified previously.";

#
# ----- store misc -----
#

$store_name = 
"The name of your store.  This might be used in the templates (depending
  on which ones you use).  It should just be a plain string.";

$store_id = 
"A unique identifier for your store.  This will be used to differentiate
  your store from others that may also be running on this copy of TallyMan.
  It should be a relatively short sequence of letters and numbers, and
  have something to do with the name of my business.

  For example, if I was building a site for 'Fishing Net, Inc.,' I would
  select something like 'fishnet' for my store id.  If my store name was
  'Uinta Golf,' I would use 'uinta'.";

$store_sample_data = 
"We can install some sample store data for you to play with.  As of 
  distribution, the sample store data that comes with TallyMan is exactly
  the same as the data you will see at http://www.tallyman.com:4242/
  You can delete or modify any of it; it is, after all, _your_ store!  The
  included sample data is merely to help you understand how the system works.";

$zb_ups_importer = 
"TallyMan comes with the ability to use real UPS shipping for its zone-based
  shipping features.  The necessary data must be entered into the database, 
  after the tables have been created.  The installer can import the data 
  automatically for you, if you want.  It often takes quite a while (around
  5 minutes).

  If you ever need to import the zone data by hand, use the 
  tools/zb_ups_import.pl script.";

$store_origin_zipcode = 
"The zipcode from which shipments will originate.  This is used by the
  UPS shipping module to calculate a shipping charge.";

$store_admin_email = 
"The email address of the store administrator.  May be used in the templates.";

$sendmail_bounceback = 
"The shopping basket automatically emails receipts when a customer has
  finalized an order.  If the customer entered an invalid email address,
  an email containing the error message will be sent to this address.";

$basket_from_address = 
"When the shopping basket mails receipts, it must specify a 'from' address.
  Enter it here.";

$sendmail_path = 
"The path to your sendmail executable.  It probably resides in 
  /usr/sbin/sendmail.  If not, ask your systems administrator where it is.
  This is used for the shopping basket's receipts.";

$global_default =
"In order to save typing, you may save the parameters you have specified
  here as a 'global store template.'  The values that you have supplied here
  will appear as the default values for other stores that you create.

  You may either use these values for this session alone, or for future
  sessions as well.  If you elect to only use the values for this session,
  they will be lost (unless you edit a store).  Using the values for future
  sessions is a way to 'save' your work.";

#
# -----------------------------------------------------------------------------
#

1;
