#!/usr/bin/perl

use lib '/home/jason/egen/tallyman/lib';
$ENV{TALLYMAN_SID} = 'default';
$ENV{TALLYMAN_PATH} = '/home/jason/egen/tallyman';

use LAYIM;

if($#ARGV != 0) {
print <<EOF;

Usage: 
    $0 picture.txt

Where picture.txt is a picture of the layout you want.  Things listed must
already have been created.  Use !ROOT! for the root node.

EOF
exit 1;
}
$| =1;

open(INFILE, "< $ARGV[0]") or die("Can't open picture file $ARGV[0]: $!");
my $picture = join('', <INFILE>);

($status, $reason) = LAYIM::layout_import($picture);
print $reason, "\n";

