#!/usr/bin/perl

# up2.0a3-2.0b5.pl
# upgrades Tallyman from version 2.0a3 to 2.0b5

# 24 Jan 2000
# Jason E. Holt
# for Akopia, Inc.
# jason@akopia.com


$| = 1;

use Getopt::Long;

$usage = <<EOF;
usage:

$0  [--help]  [--verbose]  [--force] 
                    [--tallyman-sid=STORE ID]  [--tallyman-path=PATH]
                    [--not-really]  [--upgrade-all]
EOF

# Setting TALLYMAN_PATH:
# --tallyman-path has first precedence, then 
# the environment var, then ../..

################### Parse the options
if(!GetOptions('verbose'         => \$VERBOSE,
		  'force'           => \$FORCE,
		  'tallyman-sid=s'  => \$TM_SID,
		  'tallyman-path=s' => \$ENV{TALLYMAN_PATH},
		  'not-really'      => \$NOT_REALLY,
		  'upgrade-all'     => \$DO_ALL,
		  'help'            => \$HELP
		  ) || $HELP) {
print <<EOF;

$usage

Upgrades a Tallyman 2.0a3 installation to 2.0b5.

Option descriptions:

    --help           Display this message
    --verbose        Show details while upgrading
    --force          Upgrade even if the version appears to be wrong
    --tallyman-sid   Specify a specific store id to upgrade
    --tallyman-path  Specify the base directory of a Tallyman installation
    --not-really     Just pretend to upgrade.  Useful with --verbose
    --upgrade-all    Non-interactively attempt to upgrade all installed stores

EOF
    exit 1;
}
    

################### Load the tm libs
unless($ENV{TALLYMAN_PATH}) {
    chdir "../..";
    $ENV{TALLYMAN_PATH} = `pwd`;
    chomp $ENV{TALLYMAN_PATH};
    print "\nUsing '$ENV{TALLYMAN_PATH}' for TALLYMAN_PATH.\n\n";
}

unless(eval "
             use lib '$ENV{TALLYMAN_PATH}/lib';
             use KNAR;
             use ACCESS;
             1;
            ") {

    print <<EOF;

The following error occurred when trying to load the Tallyman
libraries: 

$@

EOF

    exit 1;
}

$TM_SID eq 'default' && die "'default' isn't a real store.";
$TM_SID eq 'CVS'     && die "'CVS' isn't a real store.";

chdir("$ENV{TALLYMAN_PATH}/stores") || die 
    "Can't cd to $ENV{TALLYMAN_PATH}/stores: $!";

@sids = ($TM_SID || <*>);
foreach $sid (@sids) {

    next if $sid eq "default";
    next if $sid eq "CVS";

    $ENV{TALLYMAN_SID} = $sid;

    unless($DO_ALL || $TM_SID) {
	print "Attempt to upgrade store '$sid' [y/n]: ";
	my $answer = <>;
	unless ($answer =~ /^[yY]/) {
	    print "Skipping.\n";
	    next;
	}
    }

    print "Store '$sid': ";

    ################### Verify tm version
    if(!$FORCE && ($ver = KNAR::knar_entry_get('Tallyman Version'))) {

	print "skipping (wrong version).\n";
	$VERBOSE && print <<EOF;

The 'Tallyman Version' entry in the KNAR table suggests that you're
running version '$ver' of Tallyman.  This script only knows how to 
upgrade from version 2.0a3 to 2.0b5.  Specify --force to attempt
anyway (at your own risk).

EOF
        # ' silly emacs
        next;
    } else {
	print "attempting to upgrade.\n";
    }

    &do_upgrade($VERBOSE, $NOT_REALLY);
}

print "\nExit.\n";


sub do_upgrade {
    my($VERBOSE, $NOT_REALLY) = @_;


    DBLIB::db_transact_begin() unless $NOT_REALLY;

    ################### Create the new permissions
    my(@do_create) = 
	qw(layout_view_list layout_create layout_edit layout_delete);

    my $created_flag = 0;
    foreach (@do_create) {
	$VERBOSE && print "Checking for permission $_... ";
    
	if(ACCESS::access_perm_find_by_name('layout_view_list')){
	    $VERBOSE && print "already exists.\n";
	} else {
	    $created_flag = 1;
	    $NOT_REALLY && $VERBOSE && print "(not really) ";
	    $VERBOSE && print "Creating.\n";
	    ACCESS::access_perm_create('name', $_) unless $NOT_REALLY;
	}
    }

    if($created_flag) {
	print "\n";
	$NOT_REALLY && print "(not really) ";
	print 
        "New permissions added. Don't forget to update user settings.\n\n";
    }

    ################### Create the new knar entries
    my(%do_create) = ('Show advanced stock fields' => '0',
		      'Show hidden fields'         => '0' );
    foreach (keys %do_create) {
	unless(defined(KNAR::knar_entry_get($_))) {
	    $NOT_REALLY && $VERBOSE && print "(not really) ";
	    $VERBOSE && print "Setting knar entry '$_' to: $do_create{$_}\n";
	    KNAR::knar_entry_set_by_name($_, $do_create{$_}, '') 
		unless $NOT_REALLY;
	} else {
	    $VERBOSE && print "Skipping existing knar entry $_.\n";
	}
    }

    $NOT_REALLY && $VERBOSE && print "(not really) ";
    $VERBOSE && print "Setting Tallyman Version to 2.0b5\n";
    KNAR::knar_entry_set_by_name("Tallyman Version", '2.0b5', '') 
	unless $NOT_REALLY;

    DBLIB::db_transact_end() unless $NOT_REALLY;
}

