#!/usr/bin/perl

# zb_ups_test.pl
#   copyright (c) 1999 akopia, inc.
#
######################################################################
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of version 2 of the GNU General Public
#   License as published by the Free Software Foundation.
#    
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
######################################################################

# Test the UPS zone-based shipping package.

#
# -----------------------------------------------------------------------------
#
# make sure that MILTON can find us.
#

BEGIN {
  if (($#ARGV != 3) && ($#ARGV !=4)) {
    die "usage: zb_ups_test <milton_path> <storeid> <weight> <dest zipcode>\n";
  }

  if (!defined($ENV{'TALLYMAN_PATH'})) {
    $ENV{'TALLYMAN_PATH'} = $ARGV[0];
  }

  if (!defined($ENV{'TALLYMAN_SID'})) {
    $ENV{'TALLYMAN_SID'} = $ARGV[1];
  }
}

use lib "$ENV{'TALLYMAN_PATH'}/lib";
use MILTON;
use SHIPPING;

#
# -----------------------------------------------------------------------------
#

$weight = $ARGV[2];
$dest = $ARGV[3];

$ground    = SHIPPING->zb_ups_calc_charge_ground($dest,$weight);
$next      = SHIPPING->zb_ups_calc_charge_next_day_air($dest,$weight);
$nextsaver = SHIPPING->zb_ups_calc_charge_next_day_air_saver($dest,$weight);
$second    = SHIPPING->zb_ups_calc_charge_second_day_air($dest,$weight);
$secondam  = SHIPPING->zb_ups_calc_charge_second_day_air_am($dest,$weight);
$three     = SHIPPING->zb_ups_calc_charge_three_day_select($dest,$weight);

print "Results to $dest weighing $weight pounds:\n";
print "  Ground:           \$$ground\n";
print "  Next day:         \$$next\n";
print "  Next day saver:   \$$nextsaver\n";
print "  Second day:       \$$second\n";
print "  Second day A.M.:  \$$secondam\n";
print "  Three day select: \$$three\n";
print "\n";
