MS17-010 fixes RCE in SMBv1, but seems to also have inadvertently added a remote, uncredentialed
patch check information disclosure.

This module can determine if MS17-010 has been patched or not. Specifically, it connects to the
IPC$ tree and attempts a PeekNamedPipe transaction on FID 0.

If the status returned is "STATUS_INSUFF_SERVER_RESOURCES", the machine does not have the MS17-010
patch. After the patch, Win10 returns "STATUS_ACCESS_DENIED" and other Windows versions
"STATUS_INVALID_HANDLE". In case none of these are detected, the module says it was not able to
detect the patch level.

This module does not require valid SMB credentials in default server configurations. It can log on
as the user "" and connect to IPC$.

## Vulnerable Application

To use smb_ms17_010, make sure you are able to connect to a SMB service that supports SMBv1.

## Verification Steps

The following demonstrates a basic scenario of an unpatched system.

```
msf > use auxiliary/scanner/smb/smb_ms17_010
msf auxiliary(smb_ms17_010) > set RHOSTS 192.168.1.104
RHOSTS => 192.168.1.104
msf auxiliary(smb_ms17_010) > run

[*] 192.168.1.104:445    - Connected to \\192.168.1.104\IPC$ with TID = 2048
[*] 192.168.1.104:445    - Received STATUS_INSUFF_SERVER_RESOURCES with FID = 0
[!] 192.168.1.104:445    - Host is likely VULNERABLE to MS17-010!
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
```

If you run the same scan on the system after patching, you should see the following:

```
msf auxiliary(smb_ms17_010) > run

[*] 192.168.1.104:445    - Connected to \\192.168.1.104\IPC$ with TID = 2052
[*] 192.168.1.104:445    - Received STATUS_ACCESS_DENIED with FID = 0
[+] 192.168.1.104:445    - Host does NOT appear vulnerable.
[*] Scanned 1 of 1 hosts (100% complete)
[*] Auxiliary module execution completed
```

## Options

By default, the smb_ms17_010 module only requires the RHOSTS option to run. In a default configuration,
you will not need valid credentials to connect to the IPC$ share. But, if you have them, it can't hurt.

### The SMBUser option

If you are testing a specific user, use this option.

```
set SMBUser [user name]
```

### The SMBPass option

If you are testing a specific password, use this option.

```
set SMBPass [password]
```
