(ert-deftest pyvenv-activate ()
  "`pyvenv-activate' should set the correct variables."
  (with-temp-virtualenv tmpdir
    (let* ((process-environment process-environment)
           (exec-path exec-path)
           (pyvenv-virtual-env nil)
           (pyvenv-virtual-env-name nil)
           (pyvenv-old-process-environment nil)
           (pyvenv-old-exec-path nil)
           (pre-activate-venv nil)
           (post-activate-venv nil)
           (pyvenv-pre-activate-hooks
            (list (lambda ()
                    (setq pre-activate-venv pyvenv-virtual-env))))
           (pyvenv-post-activate-hooks
            (list (lambda ()
                    (setq post-activate-venv pyvenv-virtual-env)))))
      (pyvenv-activate tmpdir)
      (should (f-equal? pre-activate-venv tmpdir))
      (should (f-equal? post-activate-venv tmpdir))
      (should (f-equal? pyvenv-virtual-env tmpdir))
      (should (equal pyvenv-virtual-env-name (file-name-base tmpdir)))
      (should (equal python-shell-virtualenv-path tmpdir))
      (should (equal python-shell-virtualenv-root tmpdir))
      (should (equal (getenv "VIRTUAL_ENV")
                     tmpdir))
      (should (string-match (format "^%s/bin" (regexp-quote tmpdir))
                            (getenv "PATH")))
      (should (equal (getenv "PYTHONHOME")
                     nil))
      (should (member (format "%s/bin" tmpdir)
                      exec-path)))))
