% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{Assay-methods}
\alias{Assay-methods}
\alias{[.Assay}
\alias{[[.Assay}
\alias{dim.Assay}
\alias{dimnames.Assay}
\alias{head.Assay}
\alias{merge.Assay}
\alias{subset.Assay}
\alias{tail.Assay}
\alias{[[<-,Assay,ANY,ANY,ANY-method}
\alias{colMeans,Assay-method}
\alias{colSums,Assay-method}
\alias{rowMeans,Assay-method}
\alias{rowSums,Assay-method}
\alias{show,Assay-method}
\title{\code{Assay} Methods}
\usage{
\method{[}{Assay}(x, i, j, ...)

\method{[[}{Assay}(x, i, ..., drop = FALSE)

\method{dim}{Assay}(x)

\method{dimnames}{Assay}(x)

\method{head}{Assay}(x, n = 10L, ...)

\method{merge}{Assay}(x = NULL, y = NULL, add.cell.ids = NULL, merge.data = TRUE, ...)

\method{subset}{Assay}(x, cells = NULL, features = NULL, ...)

\method{tail}{Assay}(x, n = 10L, ...)

\S4method{[[}{Assay,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{colMeans}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{colSums}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowMeans}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowSums}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{show}{Assay}(object)
}
\arguments{
\item{x, object}{An \code{\link{Assay}} object}

\item{i, features}{For \code{[[}: metadata names; for all other methods,
feature names or indices}

\item{j, cells}{Cell names or indices}

\item{...}{Arguments passed to other methods}

\item{drop}{See \code{\link[base]{drop}}}

\item{n}{an integer vector of length up to \code{dim(x)} (or 1,
    for non-dimensioned objects). Values specify the indices to be
    selected in the corresponding dimension (or along the length) of the
    object. A positive value of \code{n[i]} includes the first/last
    \code{n[i]} indices in that dimension, while a negative value
    excludes the last/first \code{abs(n[i])}, including all remaining
    indices. \code{NA} or non-specified values (when \code{length(n) <
      length(dim(x))}) select all indices in that dimension. Must
    contain at least one non-missing value.}

\item{y}{A vector or list of one or more objects to merge}

\item{add.cell.ids}{A character vector of \code{length(x = c(x, y))};
appends the corresponding values to the start of each objects' cell names}

\item{merge.data}{Merge the data slots instead of just merging the counts
(which requires renormalization); this is recommended if the same
normalization approach was applied to all objects}

\item{value}{Additional metadata to add}

\item{na.rm}{logical.  Should missing values (including \code{NaN})
    be omitted from the calculations?}

\item{dims}{completely ignored by the \code{Matrix} methods.}

\item{slot}{Name of assay expression matrix to calculate column/row
means/sums on}
}
\value{
\code{[}: The \code{data} slot for features \code{i} and cells
\code{j}

\code{[[}: The feature-level metadata for \code{i}

\code{dim}: The number of features (\code{nrow}) and cells
(\code{ncol})

\code{dimnames}: Feature (row) and cell (column) names

\code{head}: The first \code{n} rows of feature-level metadata

\code{merge}: Merged object

\code{subset}: A subsetted \code{Assay}

\code{tail}: The last \code{n} rows of feature-level metadata

\code{[[<-}: \code{x} with metadata \code{value} added as \code{i}

\code{colMeans}: The column (cell-wise) means of \code{slot}

\code{colSums}: The column (cell-wise) sums of \code{slot}

\code{rowMeans}: The row (feature-wise) means of \code{slot}

\code{rowSums}: The row (feature-wise) sums of \code{slot}

\code{show}: Prints summary to \code{\link[base]{stdout}} and
invisibly returns \code{NULL}
}
\description{
Methods for \code{\link{Assay}} objects for generics defined in
other packages
}
\section{Functions}{
\itemize{
\item \code{[}: Get expression data from an \code{Assay}

\item \code{[[}: Get feature-level metadata

\item \code{dim(Assay)}: Number of cells and features for an \code{Assay}

\item \code{dimnames(Assay)}: Cell- and feature-names for an \code{Assay}

\item \code{head(Assay)}: Get the first rows of feature-level metadata

\item \code{merge(Assay)}: Merge \code{Assay} objects

\item \code{subset(Assay)}: Subset an \code{Assay}

\item \code{tail(Assay)}: Get the last rows of feature-level metadata

\item \code{`[[`(x = Assay, i = ANY, j = ANY) <- value}: Add feature-level metadata

\item \code{colMeans(Assay)}: Calculate \code{\link[base]{colMeans}} on an
\code{Assay}

\item \code{colSums(Assay)}: Calculate \code{\link[base]{colSums}} on an
\code{Assay}

\item \code{rowMeans(Assay)}: Calculate \code{\link[base]{rowMeans}} on an
\code{Assay}

\item \code{rowSums(Assay)}: Calculate \code{\link[base]{rowSums}} on an
\code{Assay}

\item \code{show(Assay)}: Overview of an \code{Assay} object

}}
\concept{assay}
