import { Connection } from "vscode-languageserver";
import { WorkspaceFolderContext } from "../services/workspaceManager";
import { ExtensionSettings } from "../interfaces/extensionSettings";
export declare class CommandRunner {
    private connection;
    private context;
    private settings;
    constructor(connection: Connection | undefined, context: WorkspaceFolderContext, settings: ExtensionSettings);
    runCommand(executable: string, args: string, workingDirectory?: string, mountPaths?: Set<string>): Promise<{
        stdout: string;
        stderr: string;
    }>;
    /**
     * A method to return the path to the provided executable
     * @param executable - String representing the name of the executable
     * @returns Complete path of the executable (string) or undefined depending upon the presence of the executable
     */
    getExecutablePath(executable: string): Promise<string | undefined>;
}
