﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudsearch/CloudSearch_EXPORTS.h>
#include <aws/cloudsearch/model/AnalysisScheme.h>
#include <aws/cloudsearch/model/OptionStatus.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace CloudSearch {
namespace Model {

/**
 * <p>The status and configuration of an <code>AnalysisScheme</code>.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudsearch-2013-01-01/AnalysisSchemeStatus">AWS
 * API Reference</a></p>
 */
class AnalysisSchemeStatus {
 public:
  AWS_CLOUDSEARCH_API AnalysisSchemeStatus() = default;
  AWS_CLOUDSEARCH_API AnalysisSchemeStatus(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_CLOUDSEARCH_API AnalysisSchemeStatus& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_CLOUDSEARCH_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_CLOUDSEARCH_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{

  inline const AnalysisScheme& GetOptions() const { return m_options; }
  inline bool OptionsHasBeenSet() const { return m_optionsHasBeenSet; }
  template <typename OptionsT = AnalysisScheme>
  void SetOptions(OptionsT&& value) {
    m_optionsHasBeenSet = true;
    m_options = std::forward<OptionsT>(value);
  }
  template <typename OptionsT = AnalysisScheme>
  AnalysisSchemeStatus& WithOptions(OptionsT&& value) {
    SetOptions(std::forward<OptionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const OptionStatus& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = OptionStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = OptionStatus>
  AnalysisSchemeStatus& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}
 private:
  AnalysisScheme m_options;
  bool m_optionsHasBeenSet = false;

  OptionStatus m_status;
  bool m_statusHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudSearch
}  // namespace Aws
