/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.time.Clock;

public class ExpiringValue<V> {
    private V value;
    private long lastAccessTime;
    private long expirationTimeInMillis;
    private Clock clock;

    public ExpiringValue(V value, long expirationTimeInMillis, Clock clock) {
        this.value = value;
        this.expirationTimeInMillis = expirationTimeInMillis;
        this.clock = clock;
        this.updateLastAccessTime();
    }

    public V getValue() {
        this.updateLastAccessTime();
        return this.value;
    }

    public boolean isExpired() {
        return this.isExpired(this.clock.millis());
    }

    public boolean isExpired(long currentTimeMillis) {
        return currentTimeMillis - this.lastAccessTime >= this.expirationTimeInMillis;
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = this.clock.millis();
    }
}

