/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class CompletionStageUtils {
    private CompletionStageUtils() {
    }

    public static <T> CompletionStage<T> recover(CompletionStage<T> completionStage, Function<Throwable, T> exceptionHandler) {
        return completionStage.exceptionally(exceptionHandler);
    }

    public static <T> CompletionStage<T> recover(CompletionStage<T> completionStage, List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
        CompletableFuture promise = new CompletableFuture();
        completionStage.whenComplete((result2, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException || throwable instanceof ExecutionException) {
                    CompletionStageUtils.tryRecover(exceptionTypes, exceptionHandler, promise, throwable.getCause());
                } else {
                    CompletionStageUtils.tryRecover(exceptionTypes, exceptionHandler, promise, throwable);
                }
            } else {
                promise.complete(result2);
            }
        });
        return promise;
    }

    public static <X extends Throwable, T> CompletionStage<T> recover(CompletionStage<T> completionStage, Class<X> exceptionType, Function<Throwable, T> exceptionHandler) {
        CompletableFuture promise = new CompletableFuture();
        completionStage.whenComplete((result2, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException || throwable instanceof ExecutionException) {
                    CompletionStageUtils.tryRecover(exceptionType, exceptionHandler, promise, throwable.getCause());
                } else {
                    CompletionStageUtils.tryRecover(exceptionType, exceptionHandler, promise, throwable);
                }
            } else {
                promise.complete(result2);
            }
        });
        return promise;
    }

    private static <T> void tryRecover(List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler, CompletableFuture<T> promise, Throwable throwable) {
        if (exceptionTypes.stream().anyMatch(exceptionType -> exceptionType.isAssignableFrom(throwable.getClass()))) {
            try {
                promise.complete(exceptionHandler.apply(throwable));
            }
            catch (Exception fallbackException) {
                promise.completeExceptionally(fallbackException);
            }
        } else {
            promise.completeExceptionally(throwable);
        }
    }

    private static <X extends Throwable, T> void tryRecover(Class<X> exceptionType, Function<Throwable, T> exceptionHandler, CompletableFuture<T> promise, Throwable throwable) {
        if (exceptionType.isAssignableFrom(throwable.getClass())) {
            try {
                promise.complete(exceptionHandler.apply(throwable));
            }
            catch (Exception fallbackException) {
                promise.completeExceptionally(fallbackException);
            }
        } else {
            promise.completeExceptionally(throwable);
        }
    }

    public static <T> Supplier<CompletionStage<T>> recover(Supplier<CompletionStage<T>> completionStageSupplier, Function<Throwable, T> exceptionHandler) {
        return () -> CompletionStageUtils.recover((CompletionStage)completionStageSupplier.get(), exceptionHandler);
    }

    public static <T, X extends Throwable> Supplier<CompletionStage<T>> recover(Supplier<CompletionStage<T>> completionStageSupplier, Class<X> exceptionType, Function<Throwable, T> exceptionHandler) {
        return () -> CompletionStageUtils.recover((CompletionStage)completionStageSupplier.get(), exceptionType, exceptionHandler);
    }

    public static <T> Supplier<CompletionStage<T>> recover(Supplier<CompletionStage<T>> completionStageSupplier, List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
        return () -> CompletionStageUtils.recover((CompletionStage)completionStageSupplier.get(), exceptionTypes, exceptionHandler);
    }

    public static <T> CompletionStage<T> recover(CompletionStage<T> completionStage, Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
        return completionStage.thenApply(result2 -> {
            if (resultPredicate.test(result2)) {
                return resultHandler.apply(result2);
            }
            return result2;
        });
    }

    public static <T> Supplier<CompletionStage<T>> recover(Supplier<CompletionStage<T>> completionStageSupplier, Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
        return () -> CompletionStageUtils.recover((CompletionStage)completionStageSupplier.get(), resultPredicate, resultHandler);
    }

    public static <T, R> Supplier<CompletionStage<R>> andThen(Supplier<CompletionStage<T>> completionStageSupplier, BiFunction<T, Throwable, R> handler) {
        return () -> ((CompletionStage)completionStageSupplier.get()).handle(handler);
    }
}

