/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.interpreter.AggregateNode;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.FilterNode;
import org.apache.calcite.interpreter.ImmutableBindables;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.JoinNode;
import org.apache.calcite.interpreter.MatchNode;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.NoneToBindableConverterRule;
import org.apache.calcite.interpreter.ProjectNode;
import org.apache.calcite.interpreter.SetOpNode;
import org.apache.calcite.interpreter.SortNode;
import org.apache.calcite.interpreter.ValuesNode;
import org.apache.calcite.interpreter.WindowNode;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Match;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableSet;

@Value.Enclosing
public class Bindables {
    public static final RelOptRule BINDABLE_TABLE_SCAN_RULE = BindableTableScanRule.Config.DEFAULT.toRule();
    public static final RelOptRule BINDABLE_FILTER_RULE = BindableFilterRule.DEFAULT_CONFIG.toRule(BindableFilterRule.class);
    public static final RelOptRule BINDABLE_PROJECT_RULE = BindableProjectRule.DEFAULT_CONFIG.toRule(BindableProjectRule.class);
    public static final RelOptRule BINDABLE_SORT_RULE = BindableSortRule.DEFAULT_CONFIG.toRule(BindableSortRule.class);
    public static final RelOptRule BINDABLE_JOIN_RULE = BindableJoinRule.DEFAULT_CONFIG.toRule(BindableJoinRule.class);
    public static final RelOptRule BINDABLE_SET_OP_RULE;
    public static final RelOptRule BINDABLE_SETOP_RULE;
    public static final RelOptRule BINDABLE_VALUES_RULE;
    public static final RelOptRule BINDABLE_AGGREGATE_RULE;
    public static final RelOptRule BINDABLE_WINDOW_RULE;
    public static final RelOptRule BINDABLE_MATCH_RULE;
    public static final NoneToBindableConverterRule FROM_NONE_RULE;
    public static final ImmutableList<RelOptRule> RULES;

    private Bindables() {
    }

    private static Enumerable<@Nullable Object[]> help(DataContext dataContext, BindableRel rel) {
        return new Interpreter(dataContext, rel);
    }

    static {
        BINDABLE_SETOP_RULE = BINDABLE_SET_OP_RULE = BindableSetOpRule.DEFAULT_CONFIG.toRule(BindableSetOpRule.class);
        BINDABLE_VALUES_RULE = BindableValuesRule.DEFAULT_CONFIG.toRule(BindableValuesRule.class);
        BINDABLE_AGGREGATE_RULE = BindableAggregateRule.DEFAULT_CONFIG.toRule(BindableAggregateRule.class);
        BINDABLE_WINDOW_RULE = BindableWindowRule.DEFAULT_CONFIG.toRule(BindableWindowRule.class);
        BINDABLE_MATCH_RULE = BindableMatchRule.DEFAULT_CONFIG.toRule(BindableMatchRule.class);
        FROM_NONE_RULE = NoneToBindableConverterRule.DEFAULT_CONFIG.toRule(NoneToBindableConverterRule.class);
        RULES = ImmutableList.of(FROM_NONE_RULE, BINDABLE_TABLE_SCAN_RULE, BINDABLE_FILTER_RULE, BINDABLE_PROJECT_RULE, BINDABLE_SORT_RULE, BINDABLE_JOIN_RULE, BINDABLE_SET_OP_RULE, BINDABLE_VALUES_RULE, BINDABLE_AGGREGATE_RULE, BINDABLE_WINDOW_RULE, BINDABLE_MATCH_RULE);
    }

    public static class BindableMatchRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalMatch.class, Convention.NONE, BindableConvention.INSTANCE, "BindableMatchRule").withRuleFactory(BindableMatchRule::new);

        protected BindableMatchRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalMatch match = (LogicalMatch)rel;
            RelTraitSet traitSet = match.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode input = match.getInput();
            RelNode convertedInput = BindableMatchRule.convert(input, input.getTraitSet().replace(BindableConvention.INSTANCE));
            return new BindableMatch(rel.getCluster(), traitSet, convertedInput, match.getRowType(), match.getPattern(), match.isStrictStart(), match.isStrictEnd(), match.getPatternDefinitions(), match.getMeasures(), match.getAfter(), match.getSubsets(), match.isAllRows(), match.getPartitionKeys(), match.getOrderKeys(), match.getInterval());
        }
    }

    public static class BindableMatch
    extends Match
    implements BindableRel {
        BindableMatch(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType, RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Map<String, RexNode> measures, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, ImmutableBitSet partitionKeys, RelCollation orderKeys, @Nullable RexNode interval) {
            super(cluster, traitSet, input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new BindableMatch(this.getCluster(), traitSet, inputs.get(0), this.getRowType(), this.pattern, this.strictStart, this.strictEnd, this.patternDefinitions, this.measures, this.after, this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new MatchNode(implementor.compiler, this);
        }
    }

    public static class BindableWindowRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalWindow.class, Convention.NONE, BindableConvention.INSTANCE, "BindableWindowRule").withRuleFactory(BindableWindowRule::new);

        protected BindableWindowRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalWindow winAgg = (LogicalWindow)rel;
            RelTraitSet traitSet = winAgg.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode input = winAgg.getInput();
            RelNode convertedInput = BindableWindowRule.convert(input, input.getTraitSet().replace(BindableConvention.INSTANCE));
            return new BindableWindow(rel.getCluster(), traitSet, convertedInput, winAgg.getConstants(), winAgg.getRowType(), winAgg.groups);
        }
    }

    public static class BindableWindow
    extends Window
    implements BindableRel {
        BindableWindow(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups2) {
            super(cluster, traitSet, input, constants, rowType, groups2);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new BindableWindow(this.getCluster(), traitSet, BindableWindow.sole(inputs), this.constants, this.getRowType(), this.groups);
        }

        @Override
        public Window copy(List<RexLiteral> constants) {
            return new BindableWindow(this.getCluster(), this.traitSet, this.getInput(), constants, this.getRowType(), this.groups);
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            RelOptCost cost = super.computeSelfCost(planner, mq);
            if (cost == null) {
                return null;
            }
            return cost.multiplyBy(2.0);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new WindowNode(implementor.compiler, this);
        }
    }

    public static class BindableAggregateRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, Convention.NONE, BindableConvention.INSTANCE, "BindableAggregateRule").withRuleFactory(BindableAggregateRule::new);

        protected BindableAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public @Nullable RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace(BindableConvention.INSTANCE);
            try {
                return new BindableAggregate(rel.getCluster(), traitSet, BindableAggregateRule.convert(agg.getInput(), traitSet), false, agg.getGroupSet(), agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                RelOptPlanner.LOGGER.debug(e.toString());
                return null;
            }
        }
    }

    public static class BindableAggregate
    extends Aggregate
    implements BindableRel {
        public BindableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, ImmutableList.of(), input, groupSet, groupSets, aggCalls);
            assert (this.getConvention() instanceof BindableConvention);
            for (AggregateCall aggCall : aggCalls) {
                if (aggCall.isDistinct()) {
                    throw new InvalidRelException("distinct aggregation not supported");
                }
                if (aggCall.distinctKeys != null) {
                    throw new InvalidRelException("within-distinct aggregation not supported");
                }
                AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
                if (implementor2 != null) continue;
                throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
            }
        }

        @Deprecated
        public BindableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
            this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
            BindableAggregate.checkIndicator(indicator);
        }

        @Override
        public BindableAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new BindableAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new AggregateNode(implementor.compiler, this);
        }
    }

    public static class BindableValuesRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalValues.class, Convention.NONE, BindableConvention.INSTANCE, "BindableValuesRule").withRuleFactory(BindableValuesRule::new);

        protected BindableValuesRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalValues values2 = (LogicalValues)rel;
            return new BindableValues(values2.getCluster(), values2.getRowType(), values2.getTuples(), values2.getTraitSet().replace(BindableConvention.INSTANCE));
        }
    }

    public static class BindableValues
    extends Values
    implements BindableRel {
        BindableValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new BindableValues(this.getCluster(), this.getRowType(), this.tuples, traitSet);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new ValuesNode(implementor.compiler, this);
        }
    }

    public static class BindableMinus
    extends Minus
    implements BindableRel {
        public BindableMinus(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public BindableMinus copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new BindableMinus(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new SetOpNode(implementor.compiler, this);
        }
    }

    public static class BindableIntersect
    extends Intersect
    implements BindableRel {
        public BindableIntersect(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public BindableIntersect copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new BindableIntersect(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new SetOpNode(implementor.compiler, this);
        }
    }

    public static class BindableUnion
    extends Union
    implements BindableRel {
        public BindableUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public BindableUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new BindableUnion(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new SetOpNode(implementor.compiler, this);
        }
    }

    public static class BindableSetOpRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(SetOp.class, Convention.NONE, BindableConvention.INSTANCE, "BindableSetOpRule").withRuleFactory(BindableSetOpRule::new);

        protected BindableSetOpRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            SetOp setOp = (SetOp)rel;
            BindableConvention out = BindableConvention.INSTANCE;
            RelTraitSet traitSet = setOp.getTraitSet().replace(out);
            if (setOp instanceof LogicalUnion) {
                return new BindableUnion(rel.getCluster(), traitSet, BindableSetOpRule.convertList(setOp.getInputs(), out), setOp.all);
            }
            if (setOp instanceof LogicalIntersect) {
                return new BindableIntersect(rel.getCluster(), traitSet, BindableSetOpRule.convertList(setOp.getInputs(), out), setOp.all);
            }
            return new BindableMinus(rel.getCluster(), traitSet, BindableSetOpRule.convertList(setOp.getInputs(), out), setOp.all);
        }
    }

    public static class BindableJoin
    extends Join
    implements BindableRel {
        protected BindableJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
            super(cluster, traitSet, ImmutableList.of(), left, right, condition, variablesSet, joinType);
        }

        @Deprecated
        protected BindableJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
            this(cluster, traitSet, left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
        }

        @Override
        public BindableJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            return new BindableJoin(this.getCluster(), traitSet, left, right, conditionExpr, this.variablesSet, joinType);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new JoinNode(implementor.compiler, this);
        }
    }

    public static class BindableJoinRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalJoin.class, Convention.NONE, BindableConvention.INSTANCE, "BindableJoinRule").withRuleFactory(BindableJoinRule::new);

        protected BindableJoinRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            BindableConvention out = BindableConvention.INSTANCE;
            RelTraitSet traitSet = join.getTraitSet().replace(out);
            return new BindableJoin(rel.getCluster(), traitSet, BindableJoinRule.convert(join.getLeft(), join.getLeft().getTraitSet().replace(BindableConvention.INSTANCE)), BindableJoinRule.convert(join.getRight(), join.getRight().getTraitSet().replace(BindableConvention.INSTANCE)), join.getCondition(), join.getVariablesSet(), join.getJoinType());
        }
    }

    public static class BindableSort
    extends Sort
    implements BindableRel {
        public BindableSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
            super(cluster, traitSet, input, collation, offset, fetch);
            assert (this.getConvention() instanceof BindableConvention);
        }

        @Override
        public BindableSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
            return new BindableSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new SortNode(implementor.compiler, this);
        }
    }

    public static class BindableSortRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(Sort.class, Convention.NONE, BindableConvention.INSTANCE, "BindableSortRule").withRuleFactory(BindableSortRule::new);

        protected BindableSortRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace(BindableConvention.INSTANCE);
            RelNode input = sort.getInput();
            return new BindableSort(rel.getCluster(), traitSet, BindableSortRule.convert(input, input.getTraitSet().replace(BindableConvention.INSTANCE)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    public static class BindableProject
    extends Project
    implements BindableRel {
        public BindableProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
            super(cluster, traitSet, ImmutableList.of(), input, projects, rowType, ImmutableSet.of());
            assert (this.getConvention() instanceof BindableConvention);
        }

        @Override
        public BindableProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
            return new BindableProject(this.getCluster(), traitSet, input, projects, rowType);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new ProjectNode(implementor.compiler, this);
        }
    }

    public static class BindableProjectRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, p -> !p.containsOver(), Convention.NONE, BindableConvention.INSTANCE, "BindableProjectRule").withRuleFactory(BindableProjectRule::new);

        protected BindableProjectRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            return project.getVariablesSet().isEmpty();
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new BindableProject(rel.getCluster(), rel.getTraitSet().replace(BindableConvention.INSTANCE), BindableProjectRule.convert(project.getInput(), project.getInput().getTraitSet().replace(BindableConvention.INSTANCE)), project.getProjects(), project.getRowType());
        }
    }

    public static class BindableFilter
    extends Filter
    implements BindableRel {
        public BindableFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
            super(cluster, traitSet, input, condition);
            assert (this.getConvention() instanceof BindableConvention);
        }

        public static BindableFilter create(RelNode input, RexNode condition) {
            RelOptCluster cluster = input.getCluster();
            RelMetadataQuery mq = cluster.getMetadataQuery();
            RelTraitSet traitSet = cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.filter(mq, input));
            return new BindableFilter(cluster, traitSet, input, condition);
        }

        @Override
        public BindableFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new BindableFilter(this.getCluster(), traitSet, input, condition);
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            return new FilterNode(implementor.compiler, this);
        }
    }

    public static class BindableFilterRule
    extends ConverterRule {
        public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalFilter.class, f -> !f.containsOver(), Convention.NONE, BindableConvention.INSTANCE, "BindableFilterRule").withRuleFactory(BindableFilterRule::new);

        protected BindableFilterRule(ConverterRule.Config config) {
            super(config);
        }

        @Override
        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return BindableFilter.create(BindableFilterRule.convert(filter.getInput(), filter.getInput().getTraitSet().replace(BindableConvention.INSTANCE)), filter.getCondition());
        }
    }

    public static class BindableTableScan
    extends TableScan
    implements BindableRel {
        public final ImmutableList<RexNode> filters;
        public final ImmutableIntList projects;

        BindableTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, ImmutableList<RexNode> filters, ImmutableIntList projects) {
            super(cluster, traitSet, ImmutableList.of(), table);
            this.filters = Objects.requireNonNull(filters, "filters");
            this.projects = Objects.requireNonNull(projects, "projects");
            Preconditions.checkArgument(BindableTableScan.canHandle(table));
        }

        public static BindableTableScan create(RelOptCluster cluster, RelOptTable relOptTable) {
            return BindableTableScan.create(cluster, relOptTable, ImmutableList.of(), BindableTableScan.identity(relOptTable));
        }

        public static BindableTableScan create(RelOptCluster cluster, RelOptTable relOptTable, List<RexNode> filters, List<Integer> projects) {
            Table table = relOptTable.unwrap(Table.class);
            RelTraitSet traitSet = cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> {
                if (table != null) {
                    return table.getStatistic().getCollations();
                }
                return ImmutableList.of();
            });
            return new BindableTableScan(cluster, traitSet, relOptTable, ImmutableList.copyOf(filters), ImmutableIntList.copyOf(projects));
        }

        @Override
        public RelDataType deriveRowType() {
            RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
            List<RelDataTypeField> fieldList = this.table.getRowType().getFieldList();
            for (int project : this.projects) {
                ((RelDataTypeFactory.Builder)builder).add(fieldList.get(project));
            }
            return builder.build();
        }

        @Override
        public Class<Object[]> getElementType() {
            return Object[].class;
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).itemIf("filters", this.filters, !this.filters.isEmpty()).itemIf("projects", this.projects, !this.projects.equals(this.identity()));
        }

        @Override
        public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            boolean noPushing = this.filters.isEmpty() && this.projects.size() == this.table.getRowType().getFieldCount();
            RelOptCost cost = super.computeSelfCost(planner, mq);
            if (noPushing || cost == null) {
                return cost;
            }
            double f = this.filters.isEmpty() ? 1.0 : 0.5;
            double p = ((double)this.projects.size() + 2.0) / ((double)this.table.getRowType().getFieldCount() + 2.0);
            return cost.multiplyBy(f * p * 0.01);
        }

        public static boolean canHandle(RelOptTable table) {
            return table.maybeUnwrap(ScannableTable.class).isPresent() || table.maybeUnwrap(FilterableTable.class).isPresent() || table.maybeUnwrap(ProjectableFilterableTable.class).isPresent();
        }

        @Override
        public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
            return Bindables.help(dataContext, this);
        }

        @Override
        public Node implement(InterpretableRel.InterpreterImplementor implementor) {
            throw new UnsupportedOperationException();
        }
    }

    public static class BindableTableScanRule
    extends RelRule<Config> {
        protected BindableTableScanRule(Config config) {
            super(config);
        }

        @Deprecated
        public BindableTableScanRule(RelBuilderFactory relBuilderFactory) {
            this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalTableScan scan = (LogicalTableScan)call.rel(0);
            RelOptTable table = scan.getTable();
            if (BindableTableScan.canHandle(table)) {
                call.transformTo(BindableTableScan.create(scan.getCluster(), table));
            }
        }

        @Value.Immutable
        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = ImmutableBindables.Config.of().withOperandSupplier(b -> b.operand(LogicalTableScan.class).noInputs());

            @Override
            default public BindableTableScanRule toRule() {
                return new BindableTableScanRule(this);
            }
        }
    }
}

