/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ClassDeclarationFinder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.DeclarationStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.GotoStatement;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.OptimizeShuttle;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.linq4j.tree.VisitorImpl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class BlockBuilder {
    final List<Statement> statements = new ArrayList<Statement>();
    final Set<String> variables = new HashSet<String>();
    final Map<Expression, DeclarationStatement> expressionForReuse = new HashMap<Expression, DeclarationStatement>();
    private final boolean optimizing;
    private final @Nullable BlockBuilder parent;
    private final boolean removeUnused;
    private static final Shuttle OPTIMIZE_SHUTTLE = new OptimizeShuttle();

    private BlockBuilder(boolean optimizing, @Nullable BlockBuilder parent, boolean removeUnused) {
        this.optimizing = optimizing;
        this.parent = parent;
        this.removeUnused = removeUnused;
    }

    public BlockBuilder() {
        this(true);
    }

    public BlockBuilder(boolean optimizing) {
        this(optimizing, null);
    }

    public BlockBuilder(boolean optimizing, @Nullable BlockBuilder parent) {
        this(optimizing, parent, true);
    }

    public void clear() {
        this.statements.clear();
        this.variables.clear();
        this.expressionForReuse.clear();
    }

    public Expression append(String name, BlockStatement block) {
        return this.append(name, block, true);
    }

    public Expression append(String name, BlockStatement block, boolean optimize) {
        Statement lastStatement;
        if (!this.statements.isEmpty() && (lastStatement = this.statements.get(this.statements.size() - 1)) instanceof GotoStatement) {
            this.statements.set(this.statements.size() - 1, Expressions.statement(((GotoStatement)lastStatement).expression));
        }
        Expression result2 = null;
        IdentityHashMap<ParameterExpression, Expression> replacements = new IdentityHashMap<ParameterExpression, Expression>();
        SubstituteVariableVisitor shuttle = new SubstituteVariableVisitor(replacements);
        for (int i = 0; i < block.statements.size(); ++i) {
            Statement statement = block.statements.get(i);
            if (!replacements.isEmpty()) {
                statement = statement.accept(shuttle);
            }
            if (statement instanceof DeclarationStatement) {
                DeclarationStatement declaration = (DeclarationStatement)statement;
                if (!this.variables.contains(declaration.parameter.name)) {
                    this.add(statement);
                } else {
                    Expression x;
                    String newName = this.newName(declaration.parameter.name, optimize);
                    if (declaration.initializer != null && this.isSafeForReuse(declaration)) {
                        x = this.append(newName, declaration.initializer);
                    } else {
                        ParameterExpression pe = Expressions.parameter(declaration.parameter.type, newName);
                        DeclarationStatement newDeclaration = Expressions.declare(declaration.modifiers, pe, declaration.initializer);
                        x = pe;
                        this.add(newDeclaration);
                    }
                    statement = null;
                    result2 = x;
                    if (declaration.parameter != x) {
                        replacements.put(declaration.parameter, x);
                    }
                }
            } else {
                this.add(statement);
            }
            if (i != block.statements.size() - 1) continue;
            if (statement instanceof DeclarationStatement) {
                result2 = ((DeclarationStatement)statement).parameter;
                continue;
            }
            if (!(statement instanceof GotoStatement)) continue;
            this.statements.remove(this.statements.size() - 1);
            GotoStatement gotoStatement = (GotoStatement)statement;
            result2 = this.append_(name, Objects.requireNonNull(gotoStatement.expression, "expression"), optimize);
            if (this.isSimpleExpression(result2)) continue;
            DeclarationStatement declare = Expressions.declare(16, this.newName(name, optimize), result2);
            this.add(declare);
            result2 = declare.parameter;
        }
        return Objects.requireNonNull(result2, () -> "empty result when appending name=" + name + ", " + block);
    }

    public Expression append(String name, Expression expression) {
        return this.append(name, expression, true);
    }

    public @PolyNull Expression appendIfNotNull(String name, @PolyNull Expression expression) {
        if (expression == null) {
            return null;
        }
        return this.append(name, expression, true);
    }

    public Expression append(String name, Expression expression, boolean optimize) {
        Statement lastStatement;
        if (!this.statements.isEmpty() && (lastStatement = this.statements.get(this.statements.size() - 1)) instanceof GotoStatement) {
            this.statements.set(this.statements.size() - 1, Expressions.statement(((GotoStatement)lastStatement).expression));
        }
        return this.append_(name, expression, optimize);
    }

    private Expression append_(String name, Expression expression, boolean optimize) {
        DeclarationStatement decl;
        if (this.isSimpleExpression(expression)) {
            return expression;
        }
        if (this.optimizing && optimize && (decl = this.getComputedExpression(expression)) != null) {
            return decl.parameter;
        }
        DeclarationStatement declare = Expressions.declare(16, this.newName(name, optimize), expression);
        this.add(declare);
        return declare.parameter;
    }

    protected boolean isSimpleExpression(@Nullable Expression expr) {
        if (expr instanceof ParameterExpression || expr instanceof ConstantExpression) {
            return true;
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression una = (UnaryExpression)expr;
            return una.getNodeType() == ExpressionType.Convert && this.isSimpleExpression(una.expression);
        }
        return false;
    }

    protected boolean isSafeForReuse(DeclarationStatement decl) {
        return (decl.modifiers & 0x10) != 0 && !decl.parameter.name.startsWith("_");
    }

    protected void addExpressionForReuse(DeclarationStatement decl) {
        if (this.isSafeForReuse(decl)) {
            Expression expr = BlockBuilder.normalizeDeclaration(decl);
            this.expressionForReuse.put(expr, decl);
        }
    }

    private static boolean isCostly(DeclarationStatement decl) {
        return decl.initializer instanceof NewExpression;
    }

    private static Expression normalizeDeclaration(DeclarationStatement decl) {
        Expression expr = decl.initializer;
        Type declType = decl.parameter.getType();
        if (expr == null) {
            expr = Expressions.constant(null, declType);
        } else if (expr.getType() != declType) {
            expr = Expressions.convert_(expr, declType);
        }
        return expr;
    }

    public @Nullable DeclarationStatement getComputedExpression(Expression expr) {
        DeclarationStatement decl;
        if (this.parent != null && (decl = this.parent.getComputedExpression(expr)) != null) {
            return decl;
        }
        return this.optimizing ? this.expressionForReuse.get(expr) : null;
    }

    public void add(Statement statement) {
        this.statements.add(statement);
        if (statement instanceof DeclarationStatement) {
            DeclarationStatement decl = (DeclarationStatement)statement;
            String name = decl.parameter.name;
            if (!this.variables.add(name)) {
                throw new AssertionError((Object)("duplicate variable " + name));
            }
            this.addExpressionForReuse(decl);
        }
    }

    public void add(Expression expression) {
        this.add(Expressions.return_(null, expression));
    }

    public BlockStatement toBlock() {
        if (this.optimizing && this.removeUnused) {
            for (int i = 0; i < 10 && this.optimize(this.createOptimizeShuttle(), true); ++i) {
            }
            this.optimize(this.createFinishingOptimizeShuttle(), false);
        }
        return Expressions.block(this.statements);
    }

    private boolean optimize(Shuttle optimizer, boolean performInline) {
        int optimizeCount = 0;
        UseCounter useCounter = new UseCounter();
        for (Statement statement : this.statements) {
            if (statement instanceof DeclarationStatement && performInline) {
                DeclarationStatement decl = (DeclarationStatement)statement;
                useCounter.map.put(decl.parameter, new Slot());
            }
            if (useCounter.map.isEmpty()) continue;
            statement.accept(useCounter);
        }
        IdentityHashMap<ParameterExpression, Expression> subMap = new IdentityHashMap<ParameterExpression, Expression>(useCounter.map.size());
        InlineVariableVisitor visitor2 = new InlineVariableVisitor(subMap);
        ArrayList<Statement> oldStatements = new ArrayList<Statement>(this.statements);
        this.statements.clear();
        block5: for (Statement oldStatement : oldStatements) {
            if (oldStatement instanceof DeclarationStatement) {
                int count;
                DeclarationStatement statement = (DeclarationStatement)oldStatement;
                Slot slot = (Slot)useCounter.map.get(statement.parameter);
                int n = count = slot == null ? 0x7FFFFFF5 : slot.count;
                if (count > 1 && this.isSimpleExpression(statement.initializer)) {
                    count = 1;
                }
                if (!this.isSafeForReuse(statement)) {
                    count = 100;
                }
                if (BlockBuilder.isCostly(statement)) {
                    count = 100;
                }
                if (statement.parameter.name.startsWith("_")) {
                    count = Integer.MAX_VALUE;
                }
                if (statement.initializer instanceof NewExpression && ((NewExpression)statement.initializer).memberDeclarations != null) {
                    count = Integer.MAX_VALUE;
                }
                Expression normalized = BlockBuilder.normalizeDeclaration(statement);
                this.expressionForReuse.remove(normalized);
                switch (count) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        subMap.put(statement.parameter, normalized);
                        break;
                    }
                    default: {
                        Statement beforeOptimize = oldStatement;
                        if (!subMap.isEmpty()) {
                            oldStatement = oldStatement.accept(visitor2);
                        }
                        if (beforeOptimize != (oldStatement = oldStatement.accept(optimizer))) {
                            ++optimizeCount;
                            if (count != Integer.MAX_VALUE && oldStatement instanceof DeclarationStatement && this.isSafeForReuse((DeclarationStatement)oldStatement) && this.isSimpleExpression(((DeclarationStatement)oldStatement).initializer)) {
                                DeclarationStatement newDecl = (DeclarationStatement)oldStatement;
                                subMap.put(newDecl.parameter, BlockBuilder.normalizeDeclaration(newDecl));
                                oldStatement = OptimizeShuttle.EMPTY_STATEMENT;
                            }
                        }
                        if (oldStatement == OptimizeShuttle.EMPTY_STATEMENT) continue block5;
                        if (oldStatement instanceof DeclarationStatement) {
                            this.addExpressionForReuse((DeclarationStatement)oldStatement);
                        }
                        this.statements.add(oldStatement);
                        break;
                    }
                }
                continue;
            }
            Statement beforeOptimize = oldStatement;
            if (!subMap.isEmpty()) {
                oldStatement = oldStatement.accept(visitor2);
            }
            if (beforeOptimize != (oldStatement = oldStatement.accept(optimizer))) {
                ++optimizeCount;
            }
            if (oldStatement == OptimizeShuttle.EMPTY_STATEMENT) continue;
            this.statements.add(oldStatement);
        }
        return optimizeCount > 0;
    }

    protected Shuttle createOptimizeShuttle() {
        return OPTIMIZE_SHUTTLE;
    }

    protected Shuttle createFinishingOptimizeShuttle() {
        return ClassDeclarationFinder.create();
    }

    private String newName(String suggestion, boolean optimize) {
        if (!optimize && !suggestion.startsWith("_")) {
            suggestion = '_' + suggestion;
        }
        return this.newName(suggestion);
    }

    public String newName(String suggestion) {
        int i = 0;
        String candidate = suggestion;
        while (this.hasVariable(candidate)) {
            candidate = suggestion + i++;
        }
        return candidate;
    }

    public boolean hasVariable(String name) {
        return this.variables.contains(name) || this.parent != null && this.parent.hasVariable(name);
    }

    public BlockBuilder append(Expression expression) {
        this.add(expression);
        return this;
    }

    public BlockBuilder withRemoveUnused(boolean removeUnused) {
        return new BlockBuilder(this.optimizing, this.parent, removeUnused);
    }

    private static class Slot {
        private int count;

        private Slot() {
        }
    }

    private static class UseCounter
    extends VisitorImpl<Void> {
        private final IdentityHashMap<ParameterExpression, Slot> map = new IdentityHashMap();

        private UseCounter() {
        }

        @Override
        public Void visit(ParameterExpression parameter) {
            Slot slot = this.map.get(parameter);
            if (slot != null) {
                slot.count++;
            }
            return (Void)super.visit(parameter);
        }

        @Override
        public Void visit(DeclarationStatement declarationStatement) {
            if (declarationStatement.initializer != null) {
                declarationStatement.initializer.accept(this);
            }
            return null;
        }
    }

    private static class InlineVariableVisitor
    extends SubstituteVariableVisitor {
        InlineVariableVisitor(Map<ParameterExpression, Expression> map) {
            super(map);
        }

        @Override
        public Expression visit(UnaryExpression unaryExpression, Expression expression) {
            if (unaryExpression.getNodeType().modifiesLvalue && (expression = unaryExpression.expression) instanceof ParameterExpression) {
                return unaryExpression;
            }
            return super.visit(unaryExpression, expression);
        }

        @Override
        public Expression visit(BinaryExpression binaryExpression, Expression expression0, Expression expression1) {
            if (binaryExpression.getNodeType().modifiesLvalue && (expression0 = binaryExpression.expression0) instanceof ParameterExpression && this.map.containsKey(expression0)) {
                return expression1.accept(this);
            }
            return super.visit(binaryExpression, expression0, expression1);
        }
    }

    private static class SubstituteVariableVisitor
    extends Shuttle {
        protected final Map<ParameterExpression, Expression> map;
        private final IdentityHashMap<ParameterExpression, Boolean> actives = new IdentityHashMap();

        SubstituteVariableVisitor(Map<ParameterExpression, Expression> map) {
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Expression visit(ParameterExpression parameterExpression) {
            Expression e = this.map.get(parameterExpression);
            if (e != null) {
                try {
                    Boolean put = this.actives.put(parameterExpression, true);
                    if (put != null) {
                        throw new AssertionError((Object)("recursive expansion of " + parameterExpression + " in " + this.actives.keySet()));
                    }
                    Expression expression = e.accept(this);
                    return expression;
                }
                finally {
                    this.actives.remove(parameterExpression);
                }
            }
            return super.visit(parameterExpression);
        }
    }
}

