/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.util.Litmus;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableSet;

public class RelValidityChecker
extends RelVisitor
implements RelNode.Context {
    private int invalidCount;
    private final Deque<RelNode> stack = new ArrayDeque<RelNode>();

    @Override
    public Set<CorrelationId> correlationIds() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RelNode r : this.stack) {
            builder.addAll(r.getVariablesSet());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
        try {
            this.stack.push(node);
            if (!node.isValid(Litmus.THROW, this)) {
                ++this.invalidCount;
            }
            super.visit(node, ordinal, parent);
        }
        finally {
            this.stack.pop();
        }
    }

    public int invalidCount() {
        return this.invalidCount;
    }
}

