/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBasicCall
extends SqlCall {
    private SqlOperator operator;
    private List<@Nullable SqlNode> operandList;
    private final @Nullable SqlLiteral functionQuantifier;

    @Deprecated
    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos) {
        this(operator, ImmutableNullableList.copyOf(operands), pos, null);
    }

    public SqlBasicCall(SqlOperator operator, List<? extends @Nullable SqlNode> operandList, SqlParserPos pos) {
        this(operator, operandList, pos, null);
    }

    @Deprecated
    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos, @Nullable SqlLiteral functionQualifier) {
        this(operator, ImmutableNullableList.copyOf(operands), pos, functionQualifier);
    }

    public SqlBasicCall(SqlOperator operator, List<? extends @Nullable SqlNode> operandList, SqlParserPos pos, @Nullable SqlLiteral functionQualifier) {
        super(pos);
        this.operator = Objects.requireNonNull(operator, "operator");
        this.operandList = ImmutableNullableList.copyOf(operandList);
        this.functionQuantifier = functionQualifier;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    public SqlCall withExpanded(boolean expanded) {
        return !expanded ? this : new ExpandedBasicCall(this.operator, this.operandList, this.pos, this.functionQuantifier);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        this.operandList = SqlBasicCall.set(this.operandList, i, operand);
    }

    public void setOperator(SqlOperator operator) {
        this.operator = Objects.requireNonNull(operator, "operator");
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return this.operandList;
    }

    @Override
    public <S extends SqlNode> S operand(int i) {
        return (S)Nullness.castNonNull(this.operandList.get(i));
    }

    @Override
    public int operandCount() {
        return this.operandList.size();
    }

    @Override
    public @Nullable SqlLiteral getFunctionQuantifier() {
        return this.functionQuantifier;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getOperator().createCall(this.getFunctionQuantifier(), pos, this.operandList);
    }

    private static <E> List<@Nullable E> set(List<E> list, int i, @Nullable E e) {
        if (i == 0 && list.size() == 1) {
            return ImmutableNullableList.of(e);
        }
        @Nullable Object[] objects = list.toArray();
        objects[i] = e;
        return ImmutableNullableList.copyOf(objects);
    }

    private static class ExpandedBasicCall
    extends SqlBasicCall {
        ExpandedBasicCall(SqlOperator operator, List<? extends @Nullable SqlNode> operandList, SqlParserPos pos, @Nullable SqlLiteral functionQualifier) {
            super(operator, operandList, pos, functionQualifier);
        }

        @Override
        public boolean isExpanded() {
            return true;
        }

        @Override
        public SqlCall withExpanded(boolean expanded) {
            return expanded ? this : new SqlBasicCall(this.getOperator(), this.getOperandList(), this.pos, this.getFunctionQuantifier());
        }
    }
}

