/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlQualified {
    public final int prefixLength;
    public final @Nullable SqlValidatorNamespace namespace;
    public final SqlIdentifier identifier;

    private SqlQualified(@Nullable SqlValidatorScope scope2, int prefixLength, @Nullable SqlValidatorNamespace namespace, SqlIdentifier identifier) {
        Util.discard(scope2);
        this.prefixLength = prefixLength;
        this.namespace = namespace;
        this.identifier = identifier;
    }

    public int hashCode() {
        return Objects.hash(this.identifier.names, this.prefixLength);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SqlQualified && this.prefixLength == ((SqlQualified)obj).prefixLength && this.identifier.names.equals(((SqlQualified)obj).identifier.names);
    }

    public String toString() {
        return "{id: " + this.identifier + ", prefix: " + this.prefixLength + "}";
    }

    public static SqlQualified create(@Nullable SqlValidatorScope scope2, int prefixLength, @Nullable SqlValidatorNamespace namespace, SqlIdentifier identifier) {
        return new SqlQualified(scope2, prefixLength, namespace, identifier);
    }

    public final List<String> prefix() {
        return this.identifier.names.subList(0, this.prefixLength);
    }

    public final List<String> suffix() {
        return Util.skip(this.identifier.names, this.prefixLength);
    }
}

